*:*********************************************************************
*:
*:        Program: LOGSTAT.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 11/20/87      1:08
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:           Uses: &LOGBOOK.DBF
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* GENERATES STATISTICS ABOUT CONTACTS

STORE 0 TO qslex
STORE 0 TO qslrxcount
STORE 0 TO qsltxcount
STORE 0 TO qslowed
STORE 0 TO qsldirect
STORE 0 TO qslbureau
STORE 0 TO qslmngr
STORE 0 TO qsonumber
STORE 0 TO six
STORE 0 TO ten
STORE 0 TO fifteen
STORE 0 TO twenty
STORE 0 TO forty
STORE 0 TO eighty
STORE 0 TO onesixty
STORE 0 TO thirty
STORE 0 TO twentyfour
STORE 0 TO seventeen
STORE 0 TO modesstv
STORE 0 TO two
STORE 0 TO whatisit
STORE 0 TO modessb
STORE 0 TO modecw
STORE 0 TO modertty
STORE 0 TO modefm
STORE 0 TO modea
STORE 0 TO modeb
STORE 0 TO modej
STORE .t. TO joe
STORE 0 TO modeamtor
STORE 0 TO modepacket

DO WHILE joe
   IF joe
      USE &logbook
      GOTO BOTTOM
      STORE RECNO() TO lastqso
      CLEAR
      SET COLOR TO W+/R,W+/RB,BG+
      @ 1,20 SAY 'G3ZCZ LOG SUMMARY PROGRAM Version 1.3'
      SET COLOR TO GR+/B,W+/RB,BG+
      @ 4,1 SAY 'QSL SUMMARY'
      @ 5,1 SAY '--------------------------------'
      @ 6,1 SAY 'TOTAL NUMBER OF CONTACTS'
      SET COLOR TO W+/R,W+/RB,BG+
      @ 2,30 SAY lastqso
      SET COLOR TO GR+/B,W+/RB,BG+

      @ 2,41 SAY 'ENTRIES IN LOG FILE '
      SET COLOR TO W+/R,W+/RB,BG+

      ?? TRIM(logbook)
      SET COLOR TO GR+/B,W+/RB,BG+
      @ 7,1 SAY 'QSL CARDS SENT DIRECT'
      @ 8,1 SAY 'QSL CARDS SENT VIA BUREAU'
      @ 9,1 SAY 'QSL CARDS SENT VIA MANAGERS '
      @ 10,1 SAY 'QSL CARDS SENT '
      @ 11,1 SAY 'QSL CARDS RECEIVED'
      @ 12,1 SAY 'QSL CARDS OWED'
      @ 13,1 SAY 'QSL CARDS EXCHANGED'
      @ 4,40 SAY 'SUMMARY OF ENTRIES BY BAND'
      @ 5,40 SAY '----------------------------------------'
      @ 6,40 SAY '10  METERS'
      @ 7,40 SAY '12  METERS'
      @ 8,40 SAY '15  METERS'
      @ 9,40 SAY '17  METERS'
      @ 10,40 SAY '20  METERS'
      @ 11,40 SAY '30  METERS'
      @ 12,40 SAY '40  METERS'
      @ 13,40 SAY '80  METERS'
      @ 14,40 SAY '160 METERS'
      @ 15,40 SAY ' 6  METERS'
      @ 16,40 SAY ' 2  METERS'
      @ 17,40 SAY 'OSCAR MODE A'
      @ 18,40 SAY 'OSCAR MODE B '
      @ 19,40 SAY 'OSCAR MODE J'
      @ 20,40 SAY 'OTHERS'

      @ 15,1 SAY 'REPORT BY MODES'
      @ 16,1 SAY '----------------------------'
      @ 17,1 SAY 'SSB CONTACTS'
      @ 18,1 SAY 'CW CONTACTS'
      @ 19,1 SAY 'RTTY CONTACTS'
      @ 20,1 SAY 'FM CONTACTS'
      @ 21,1 SAY 'SSTV CONTACTS'
      @ 22,1 SAY 'AMTOR CONTACTS'
      @ 23,1 SAY 'PACKET CONTACTS'

      SET COLOR TO W+/R,W+/RB,BG+
      IF qsltxcount = 0
      ELSE
         @ 10,27 SAY qsltxcount
      ENDIF
      IF qslbureau = 0
      ELSE
         @ 8,27 SAY qslbureau
      ENDIF
      IF qsldirect = 0
      ELSE
         @ 7,27 SAY qsldirect
      ENDIF
      IF qslmngr = 0
      ELSE
         @ 9,27 SAY qslmngr
      ENDIF
      IF qslrxcount = 0
      ELSE
         @ 11,27 SAY qslrxcount
      ENDIF
      IF qslowed = 0
      ELSE
         @ 12,27 SAY qslowed
      ENDIF
      IF qslex = 0
      ELSE
         @ 13,27 SAY qslex
      ENDIF
      IF ten = 0
      ELSE
         @ 6,60 SAY ten
      ENDIF
      IF fifteen = 0
      ELSE
         @ 8,60 SAY fifteen
      ENDIF
      IF twenty = 0
      ELSE
         @ 10,60 SAY twenty
      ENDIF
      IF forty = 0
      ELSE
         @ 12,60 SAY forty
      ENDIF
      IF eighty = 0
      ELSE
         @ 13,60 SAY eighty
      ENDIF
      IF onesixty = 0
      ELSE
         @ 14,60 SAY onesixty
      ENDIF
      IF two = 0
      ELSE
         @ 16,60 SAY two
      ENDIF
      IF six = 0
      ELSE
         @ 15,60 SAY six
      ENDIF
      IF twentyfour = 0
      ELSE
         @  7,60 SAY twentyfour
      ENDIF
      IF seventeen = 0
      ELSE
         @ 9,60 SAY seventeen
      ENDIF
      IF thirty = 0
      ELSE
         @ 11,60 SAY thirty
      ENDIF
      IF modea = 0
      ELSE
         @ 17,60 SAY modea
      ENDIF
      IF modeb = 0
      ELSE
         @ 18,60 SAY modeb
      ENDIF
      IF modej = 0
      ELSE
         @ 19,60 SAY modej
      ENDIF
      IF whatisit  = 0
      ELSE
         @ 20,60 SAY whatisit
      ENDIF
      IF modessb = 0
      ELSE
         @ 17,21 SAY modessb
      ENDIF
      IF modecw = 0
      ELSE
         @ 18,21 SAY modecw
      ENDIF
      IF modertty = 0
      ELSE
         @ 19,21 SAY modertty
      ENDIF
      IF modefm = 0
      ELSE
         @ 20,21 SAY modefm
      ENDIF
      IF modesstv = 0
      ELSE
         @ 21,21 SAY modesstv
      ENDIF
      IF modeamtor = 0
      ELSE
         @ 22,21 SAY modemtor
      ENDIF
      IF modepacket = 0
      ELSE
         @ 23,21 SAY modepacket
      ENDIF
      GOTO TOP
      DO WHILE .not. EOF()
      SET COLOR TO RG+/R,W+/RB,BG+

         @ 2,1  SAY CALL
         @ 2,12 SAY DATE
         @ 2,22 SAY TIME
      SET COLOR TO W+/R,W+/RB,BG+

         * don't count contest title entries
         IF SUBSTR(CALL,1,1) = '-'
         ELSE
            STORE qsonumber + 1 TO qsonumber
            @ 6,27 SAY qsonumber
            IF qslsent = '-'  .or. qslsent = 'X' .or. qslsent =  'N'
            ELSE
               STORE qsltxcount + 1 TO qsltxcount
               @ 10,27 SAY qsltxcount
            ENDIF
            
            IF qslrx = '-'
               * sum cards owed only
               IF qslsent = 'B'
                  STORE qslbureau + 1 TO qslbureau
                  @ 8,27 SAY qslbureau
               ENDIF
               IF qslsent = 'D'
                  STORE qsldirect + 1 TO qsldirect
                  @ 7,27 SAY qsldirect
               ENDIF
               IF qslsent = 'M'
                  STORE qslmngr + 1 TO qslmngr
                  @ 9,27 SAY qslmngr
               ENDIF
            ELSE
               STORE qslrxcount + 1 TO qslrxcount
               @ 11,27 SAY qslrxcount
               IF qslsent = '-'
                  STORE qslowed + 1 TO qslowed
                  @ 12,27 SAY qslowed
               ELSE
                  STORE qslex + 1 TO qslex
                  @ 13,27 SAY qslex
               ENDIF
            ENDIF
            
            DO CASE
               
            CASE band = '10'
               STORE ten + 1 TO ten
               @ 6,60 SAY ten
               
            CASE band = '15'
               STORE fifteen + 1 TO fifteen
               @ 8,60 SAY fifteen
               
            CASE band = '20'
               STORE twenty + 1 TO twenty
               @ 10,60 SAY twenty
               
            CASE band = '40'
               STORE forty + 1 TO forty
               @ 12,60 SAY forty
               
            CASE band = '75'
               STORE eighty + 1 TO eighty
               @ 13,60 SAY eighty
               * 75 and 80 Meters are part of same band
               
            CASE band = '80'
               STORE eighty + 1 TO eighty
               @ 13,60 SAY eighty
               
            CASE band = '160'
               STORE onesixty + 1 TO onesixty
               @ 14,60 SAY onesixty

            CASE band = '2'
               STORE two + 1 TO two
               @ 16,60 SAY two
               
            CASE band = '6'
               STORE six + 1 TO six
               @ 15,60 SAY six
               
            CASE band = '12'
               STORE twentyfour + 1 TO twentyfour
               @  7,60 SAY twentyfour
               
            CASE band = '17'
               STORE seventeen + 1 TO seventeen
               @ 9,60 SAY seventeen
               
            CASE band = '30'
               STORE thirty + 1 TO thirty
               @ 11,60 SAY thirty
               
            CASE band = 'A'
               STORE modea + 1 TO modea
               @ 17,60 SAY modea
               
            CASE band = 'B'
               STORE modeb + 1 TO modeb
               @ 18,60 SAY modeb
               
            CASE band = 'J'
               STORE modej + 1 TO modej
               @ 19,60 SAY modej
               
            OTHERWISE
               IF SUBSTR(CALL,1,1) = '-'
               ELSE
                  STORE whatisit  + 1 TO whatisit
                  @ 20,60 SAY whatisit
               ENDIF
               
            ENDCASE
            
            DO CASE
               
            CASE mode = 'SSB'
               STORE modessb + 1 TO modessb
               @ 17,21 SAY modessb
               
            CASE mode = 'CW'
               STORE modecw + 1 TO modecw
               @ 18,21 SAY modecw
               
            CASE mode = 'RTTY'
               STORE modertty + 1 TO modertty
               @ 19,21 SAY modertty

            CASE mode = 'FM'
               STORE modefm + 1 TO modefm
               @ 20,21 SAY modefm
               
            CASE mode = 'SSTV'
               STORE modesstv + 1 TO modesstv
               @ 21,21 SAY modesstv
               
            CASE mode = 'AMTR'
               STORE modeamtor +1 TO modeamtor
               @ 22,21 SAY modeamtor
               
            CASE mode = 'PCKT'
               STORE modepacket +1 TO modepacket
               @ 23,21 SAY modepacket
            ENDCASE
         ENDIF
         SKIP
      ENDDO
      SET COLOR TO GR+/B,W+/RB,BG+
      @ 23,1 SAY ' '
      ACCEPT 'Do you want to add another log file (Y/N) ? ' TO df
      IF SUBSTR(df,1,1) = 'Y'
         @ 23,1 SAY ' '
         ACCEPT 'What is the name of the new logbook (D:NAME) ? ' TO logbook
         IF FILE(logbook)
         ELSE
            STORE .F. TO joe
            ? 'ERROR LOG FILE DOES NOT EXIST'
            WAIT
         ENDIF
      ELSE
         STORE .F. TO joe
      ENDIF
   ENDIF
ENDDO
CLEAR

* print summary
STORE ' ' TO df
ACCEPT ' Do you want hard copy of summary (Y/N) ? ' TO df
IF SUBSTR(df,1,1) = 'Y'
   SET PRINT ON
ENDIF

? 'QSL SUMMARY'
?
? 'TOTAL NUMBER OF CONTACTS    '
?? qsonumber
? 'QSL CARDS SENT DIRECT       '
?? qsldirect
? 'QSL CARDS SENT VIA BUREAU   '
?? qslbureau
? 'QSL CARDS SENT VIA MANAGERS '
?? qslmngr
? 'QSL CARDS SENT              '
?? qsltxcount
? 'QSL CARDS RECEIVED          '
?? qslrxcount
? 'QSL CARDS OWED              '
?? qslowed
? 'QSL CARDS EXCHANGED         ',qslex
?
?
? 'SUMMARY OF ENTRIES BY BAND'
?
? '10 METERS                  ',ten
? '12 METERS                  ',twentyfour
? '15 METERS                  ',fifteen
? '17 METERS                  ',seventeen
? '20 METERS                  ',twenty
? '30 METERS                  ',thirty
? '40 METERS                  ',forty
? '80 METERS                  ',eighty
? '160 METERS                 ',onesixty
? ' 6 METERS                  ',six
? ' 2 METERS                  ',two
? 'OSCAR MODE A               ',modea
? 'OSCAR MODE B               ',modeb
? 'OSCAR MODE J               ',modej
? 'OTHERS                     ',whatisit
?
?
? 'REPORT BY MODES'
?
? 'SSB          ',modessb
? 'CW           ',modecw
? 'RTTY         ',modertty
? 'FM           ',modefm
? 'SSTV         ',modesstv
? 'AMTOR        ',modeamtor
? 'PACKET       ',modepacket

IF SUBSTR(df,1,1) = 'Y'
   EJECT
   SET PRINT OFF
ENDIF
USE
?
?
WAIT
RELEASE modeamtor,modepacket
RELEASE qslrxcount,qsltxcount,qslowed,qsldirect,qslbureau,qslmngr
RELEASE df,qsonumber,ten,fifteen,twenty,forty,eighty,two,whatisit
RELEASE modessb,modecw,modertty,modefm,onesixty,modea,modeb,modej
RELEASE joe,lastqso,qslex,six,modesstv,thirty,seventeen,twentyfour
RETURN
*: EOF: LOGSTAT.PRG
