*:*********************************************************************
*:
*:        Program: LOGQSL1.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 06/25/90     13:35
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:           Uses: &LOGBOOK.DBF
*:               : QSL.DBF
*:
*:        Indexes: &LOGNDX
*:               : QSL.NDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* CALLED FROM logbook
*LOCAL VARIABLES callflag,callheard,linecount
* QSL.DBF ALSO USED IN DXPDNQSL.PRG

*INITIALISE EVERYTHING

SELECT 1
USE &logbook INDEX &logndx

SELECT 2
IF FILE('QSL.DBF')
ELSE
   SELECT 1
   COPY STRUCTURE TO qsl
ENDIF
IF FILE('QSL.NDX')
ELSE
   SELECT 2
   USE qsl
   INDEX ON CALL+band TO qsl
ENDIF
SELECT 2
USE qsl INDEX qsl
STORE  .t.  TO callflag
STORE '-' TO nqslsent
STORE '-' TO nqslrx
*MAIN LOOP
DO WHILE callflag
   SELECT A
   GOTO TOP
   ACCEPT "Call/Prefix (* To terminate, + To repeat) ? " TO newcall
   IF newcall = "*"
      STORE .F. TO callflag
      * Clear loop control for exit
   ELSE
      IF newcall = '+'
      ELSE
         STORE newcall TO callheard
      ENDIF
      FIND &callheard
      IF (EOF() .or. BOF())
         CLEAR
         @ 5,1 SAY callheard
         @ 5,12 SAY "does not appear to be in the log"
         ?
         ?
      ELSE
         DO WHILE CALL = callheard .and. (.not.EOF())
            CLEAR
            STORE qslsent TO  nqslsent
            STORE qslsent TO  oqslsent
            STORE qslrx   TO  nqslrx
            
            @ 12,1 SAY "DATE"
            @ 13,1 SAY "TIME"
            @ 14,1 SAY "CALL"
            @ 15,1 SAY "BAND"
            @ 16,1 SAY "POWER"
            @ 17,1 SAY "MODE"
            @ 18,1 SAY "REPORT (RX)"
            @ 19,1 SAY "REPORT (TX)"
            @ 20,1 SAY "COMMENTS"
            @ 21,1 SAY "QSLSENT"
            @ 22,1 SAY "QSLRX"
            
            @ 12,13 SAY DATE
            @ 13,13 SAY TIME
            @ 14,13 SAY CALL
            @ 15,13 SAY band
            @ 16,13 SAY Power
            @ 17,13 SAY mode
            @ 18,13 SAY rx
            @ 19,13 SAY tx
            
            @ 21,13 GET nqslsent
            @ 22,13 GET nqslrx
            READ
            
            *UPDATE ENTRY
            REPLACE qslsent WITH nqslsent
            REPLACE qslrx WITH nqslrx
            
            IF  qslsent <> '-'.and. oqslsent = '-'
               * SAVE VARIABLES
               STORE DATE TO ndate
               STORE TIME TO ntime
               STORE CALL TO ncall
               STORE band TO nband
               STORE Power TO npower
               STORE mode TO nmode
               STORE rx TO nrx
               STORE tx TO ntx
               STORE comments TO ncomments
               SELECT 2
               APPEND BLANK
               REPLACE qslsent WITH nqslsent
               REPLACE qslrx WITH nqslrx
               REPLACE DATE WITH ndate
               REPLACE TIME WITH ntime
               REPLACE CALL WITH ncall
               REPLACE band WITH nband
               REPLACE Power WITH npower
               REPLACE mode WITH nmode
               REPLACE rx WITH nrx
               REPLACE tx WITH ntx
               REPLACE comments WITH ncomments
               SELECT 1
            ENDIF
            SKIP
         ENDDO
      ENDIF
   ENDIF
ENDDO
SELECT 1
USE
SELECT 2
USE
* GET READY TO EXIT
RELEASE callflag,callheard,linecount,nqslsent,nqslrx,pf,label2
RELEASE ndate, ntime, ncall, nband, npower, nmode, nrx, ntx, ncomments
RELEASE oqslsent,newcall
RETURN

*: EOF: LOGQSL1.PRG
