*:*********************************************************************
*:
*:        Program: LOGQSL.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 05/04/90     11:54
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:          Calls: QSLPRINT.PRG
*:
*:           Uses: &LOGBOOK.DBF   
*:
*:        Indexes: &LOGNDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
*LOGQSL VERSION 871209
* CALLED FROM logbook
*LOCAL VARIABLES callflag,callheard,linecount

*INITIALISE EVERYTHING

USE &logbook INDEX &logndx
ACCEPT 'Do you want to print QSL labels (Y/N) ? ' TO pf
STORE  .t.  TO callflag
STORE '-' TO nqslsent
STORE '-' TO nqslrx
STORE '          ' TO callheard
*MAIN LOOP
DO WHILE callflag
   GOTO TOP
   STORE SUBSTR(callheard + '     ',1,10) TO callheard
   *   ACCEPT "Call/Prefix (* To terminate, + To repeat) ? " TO callheard
   @ 24,1 SAY "Call/Prefix (* To terminate) ?"
   @ 24,32  GET callheard
   READ
   IF callheard = "*"
      STORE .F. TO callflag
      * Clear loop control for exit
   ELSE
      STORE callheard TO callheard
      FIND &callheard
      IF (EOF() .or. BOF())
         CLEAR
         @ 5,1 SAY callheard
         @ 5,12 SAY "does not appear to be in the log"
         ?
         ?
      ELSE
         DO WHILE CALL = callheard .and. (.not.EOF())
            CLEAR
            STORE qslsent TO  nqslsent
            STORE qslsent TO  oqslsent
            STORE qslrx   TO  nqslrx
            
            @ 12,1 SAY "DATE"
            @ 13,1 SAY "TIME"
            @ 14,1 SAY "CALL"
            @ 15,1 SAY "BAND"
            @ 16,1 SAY "POWER"
            @ 17,1 SAY "MODE"
            @ 18,1 SAY "REPORT (RX)"
            @ 19,1 SAY "REPORT (TX)"
            @ 20,1 SAY "COMMENTS"
            @ 21,1 SAY "QSLSENT"
            @ 22,1 SAY "QSLRX"
            
            @ 12,13 SAY DATE
            @ 13,13 SAY TIME
            @ 14,13 SAY CALL
            @ 15,13 SAY band
            @ 16,13 SAY Power
            @ 17,13 SAY mode
            @ 18,13 SAY rx
            @ 19,13 SAY tx
            
            @ 21,13 GET nqslsent
            @ 22,13 GET nqslrx
            READ
            
            *UPDATE ENTRY
            REPLACE qslsent WITH nqslsent
            REPLACE qslrx WITH nqslrx
            IF pf = 'Y' .and. qslsent <> '-'.and. oqslsent = '-'
               DO qslprint
            ENDIF
            SKIP
         ENDDO
      ENDIF
   ENDIF
ENDDO
USE
* GET READY TO EXIT
RELEASE callflag,callheard,linecount,nqslsent,nqslrx,pf,label2
RELEASE oqslsent
RETURN
*: EOF: LOGQSL.PRG
