*:*********************************************************************
*:
*:        Program: LOGPRINT.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 04/27/90     15:45
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:           Uses: &LOGBOOK.DBF   
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* LOGPRINT  THIS PROGRAM PRINTS A LOG IN DATE ORDER
* COPYRIGHT Joe Kasser G3ZCZ 1985. VER 87/11/20-1
* CALLED BY LOGBOOK

* STRUCTURE FOR FILE:  B:logbook.DBF

* FLD       NAME      TYPE WIDTH   DEC
* 001     DATE         C    008
* 002     TIME         C    004
* 003     BAND         C    003
* 004     CALL         C    010
* 005     RX           C    003
* 006     TX           C    003
* 007     MODE         C    004
* 008     POWER        C    004
* 009     QSLSENT      C    001
* 010     QSLRX        C    001
* 011     COMMENTS     C    010

STORE 99  TO linecount
STORE  1  TO pagecount
STORE  0  TO first
STORE  1  TO qsonumber
STORE ' ' TO page
STORE ' ' TO firste
STORE 0   TO pnumber

CLEAR

USE &logbook
GOTO BOTTOM
IF (EOF() .or. BOF())
   ? 'LOGBOOK IS BLANK'
ELSE
   ACCEPT 'FIRST ENTRY (Number of entry to be displayed ) ? ' TO firste
   ACCEPT 'STARTING PAGE ? ' TO page
   STORE VAL(page) TO pagecount
   STORE VAL(firste) TO first
   ACCEPT 'Offset From Previous Log (If none, enter 0) ? ' TO pnumber
   STORE first - VAL(pnumber) TO first
   IF first < 1
      ? 'entry - offset is negative'
   ELSE
      * rem at BOTTOM
      IF RECNO() < first
         STORE RECNO() TO first
         ? 'Numbering Error'
      ENDIF
      STORE ' ' TO df
      ACCEPT 'Do you want a hard copy (Y/N) ? ' TO df
      df = UPPER(df)
      IF df = 'Y'
         SET PRINT ON
      ENDIF
      
      GOTO first
      STORE first + VAL(pnumber) TO qsonumber
      qsonumber = INT(qsonumber)
      pagecount = INT(pagecount)
      DO WHILE .not.EOF()
         
         IF linecount > 57
            IF df = 'Y'
               EJECT
            ENDIF
            ? 'LOGBOOK PRINTOUT  ',callsign,'PAGE',pagecount
            STORE pagecount + 1 TO pagecount
            ?
            ?
            ?  'LINE NUMBER  DATE    TIME BND  CALL      '
            ?? 'RX  TX  MODE PWR S R COMMENTS'
            ?  '----------------------------------'
            ?? '------------------------------------------'
            STORE 3 TO linecount
         ENDIF
         ? qsonumber,DATE,TIME,band,CALL,rx,tx,mode,Power,qslsent,qslrx,comments
         STORE linecount + 1 TO linecount
         STORE qsonumber + 1 TO qsonumber
         SKIP
      ENDDO
   ENDIF
   IF df = 'Y'
      EJECT
      SET PRINT OFF
   ENDIF
   ?
   RELEASE pnumber,df,firste,page,linecount,qsonumber,pagecount,first
ENDIF
WAIT
USE
RETURN
*: EOF: LOGPRINT.PRG
