*:*********************************************************************
*:
*:        Program: LOGMISCF.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 05/04/90     12:08
*:
*:      Called by: LOGBOOK.PRG                   
*:
*:          Calls: LOGUPDAT.PRG
*:               : DXPDNQSL.PRG
*:               : LOG2DBF.PRG
*:
*:           Uses: &LOGBOOK.DBF   
*:               : &JLOG          
*:               : &NEWLOG.DBF    
*:
*:        Indexes: &LOGNDX
*:               : TEMP.NDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
DO WHILE task <> '*'
   CLEAR
   SET COLOR TO W+/R,W+/RB,BG+
   @ 2,10 SAY 'MISCELLANEOUS FUNCTIONS VERSION 3.5'
   SET COLOR TO GR+/B,W+/RB,BG+
   @ 5,1 SAY 'Default LOG database is'
   SET COLOR TO W+/R,W+/RB,BG+
   @ 5,30 SAY TRIM(logbook)
   SET COLOR TO GR+/B,W+/RB,BG+
   @  8,1 SAY 'CHANGE LOG FILE                                   L'
   @  9,1 SAY 'MANUAL TRANSFER OF DATA TO  CONTEST LOGS          U'
   @ 10,1 SAY 'APPEND FROM BASIC "LOG" FILE TO "DBF" FILE        V'
   @ 11,1 SAY 'DISPLAY FILES ON DISK DRIVE                       F'
   @ 12,1 SAY 'DXPEDITION/CONTEST BATCH QSL FUNCTION             Q'
   @ 13,1 SAY '(RE) INDEX A LOGBOOK DATABASE FILE                I'
   @ 14,1 SAY 'SORT LOG BY DATE+TIME                             S'
   @ 15,1 SAY 'CHANGE OFFSET TO UTC                              T'
   @ 16,1 SAY 'CHANGE STATION OPERATOR CALL SIGN                 C'
   @ 17,1 SAY 'APPEND FROM A SECOND LOG DATA BASE                J'
   @ 18,1 SAY 'Quit this menu                                    *'
   @ 20,1 SAY 'QRU'
   @ 20,5 GET task
   task = UPPER(task)
   READ
   
   DO CASE
      
   CASE task = 'J'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         IF FILE(logbook +'.DBF')
            ACCEPT 'What is the database to be joined ? ' TO jlog
            IF FILE(jlog+'.DBF')
               USE &logbook INDEX &logndx
               SET TALK ON
               APPEND FROM &jlog
               SET TALK OFF
               ? 'STANDBY - UPDATING INDEX'
               USE
            ELSE
               ? 'ERROR- ',jlog,' does not exist'
               WAIT
            ENDIF
         ELSE
            ? 'ERROR- LOGBOOK IS NOT ON DEFAULT DRIVE'
            WAIT
         ENDIF
      ENDIF
      

   CASE task = 'U'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         IF FILE(logbook +'.DBF')
            DO logupdat
         ELSE
            ? 'ERROR- LOGBOOK IS NOT ON DEFAULT DRIVE'
            WAIT
         ENDIF
      ENDIF
      
   CASE task = 'I'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         IF FILE(logbook + '.DBF')
            USE &logbook
            SET TALK ON
            INDEX ON CALL+band TO &logndx
            SET TALK OFF
            USE
         ELSE
            ? 'ERROR- LOGBOOK IS NOT ON DEFAULT DRIVE'
            WAIT
         ENDIF
      ENDIF
      
   CASE task = 'Q'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         IF FILE(logbook + '.DBF')
            DO dxpdnqsl
         ELSE
            ? 'ERROR- LOGBOOK IS NOT ON DEFAULT DRIVE'
            WAIT
         ENDIF
      ENDIF
      
   CASE task = 'V'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         DO log2dbf
      ENDIF
      
   CASE task = 'F'
      CLEAR
      ACCEPT 'WHICH DRIVE ? ' TO diskdrive
      diskdrive = SUBSTR(diskdrive,1,1)
      STORE diskdrive + ':' TO diskdrive
      DISPLAY Files ON &diskdrive
      RELEASE diskdrive
      WAIT
      
   CASE task = 'C'
      CLEAR
      @ 10,1 SAY "CALL SIGN IS "
      @ 10,25 GET callsign
      READ
      
   CASE task = 'L'
      @ 22,1 SAY 'Which Log file ?'
      STORE SUBSTR(logbook+'        ',1,10) TO logbook
      @ 22,18 GET logbook
      STORE SUBSTR(logndx+'        ',1,10) TO logndx
      @ 22,30 SAY 'Which Index file ?'
      @ 22,49 GET logndx
      READ
      IF FILE (logbook + '.DBF')
         @ 22,1 SAY '                          '
      ELSE
         @ 22,1 SAY ' '
         ? 'ERROR, ',logbook, 'IS NOT PRESENT ON DRIVE'
         WAIT
      ENDIF
      
   CASE task = 'T'
      ACCEPT 'What is your offset to UTC (HH) ? ' TO cgmt
      STORE VAL(cgmt) TO gmt
      RELEASE cgmt
      
   CASE task = 'S'
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         STORE 'L' TO task
         WAIT
      ELSE
         IF FILE(logbook +'.DBF')
            ACCEPT ('WHAT IS THE NAME OF THE SORTED LOG FILE ? ') TO newlog
            USE &logbook
            ? 'INDEXING LOGBOOK NOW'
            SET TALK ON
            INDEX ON DATE+TIME TO temp
            SET TALK OFF
            ? 'COPYING LOGBOOK NOW'
            SET TALK ON
            COPY TO &newlog
            SET TALK OFF
            ERASE &temp+'NDX'
            USE &newlog
            ? 'RE-INDEXING NEW LOG FILE NOW'
            STORE newlog TO logbook
            SET TALK ON
            INDEX ON CALL+band TO &logndx
            SET TALK OFF
            RELEASE newlog
            USE
         ELSE
            ? 'ERROR- LOGBOOK IS NOT ON DEFAULT DRIVE'
            WAIT
         ENDIF
      ENDIF
      
      
   ENDCASE
ENDDO
STORE ' '  TO task
RELEASE jlog
RETURN
*: EOF: LOGMISCF.PRG
