*:*********************************************************************
*:
*:        Program: LOGFUNCT.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 05/04/90     13:19
*:
*:      Called by: LOGBOOK.PRG                   
*:
*:          Calls: LOGCHNGE.PRG
*:               : LOGSTAT.PRG
*:               : LOGPRINT.PRG
*:               : LOGSRCH.PRG
*:               : LOGADD.PRG
*:               : LOGQSL.PRG
*:               : LOGQSL1.PRG
*:               : LOGCALL.PRG
*:               : LOGDATE.PRG
*:
*:           Uses: LOG.DBF        
*:               : &LOGBOOK.DBF   
*:               : &TARGET.DBF    
*:
*:        Indexes: &LOGNDX
*:               : &TARGET
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* COPYRIGHT JOE KASSER G3ZCZ 1985,1986,1987,1988,1989

DO WHILE task <> '*'
   CLEAR
   SET COLOR TO W+/R,W+/RB,BG+
   @ 2,10 SAY 'G3ZCZ LOGBOOK FUNCTIONS PACKAGE VERSION 3.4'
   SET COLOR TO GR+/B,W+/RB,BG+
   @ 4,10 SAY 'Default LOG database is'
   SET COLOR TO W+/R,W+/RB,BG+
   @ 4,35 SAY TRIM(logbook)
   SET COLOR TO GR+/B,W+/RB,BG+
   
   
   *@ 4,1  SAY 'CURRENT LOGBOOK IS'
   *@ 4,21 SAY logbook
   @ 6,1  SAY 'CHANGE LOG FILE                             L'
   @ 7,1  SAY 'PRINT LOG PAGES                             P'
   @ 8,1  SAY 'PRINT LOG INDEXED BY CALL SIGN              C'
   @ 9,1  SAY 'APPEND ENTRIES                              A'
   @ 10,1 SAY 'CREATE NEW LOGBOOK DATABASE                 N'
   @ 11,1 SAY 'HUNT FOR PREFIX/CALL IN LOG                 H'
   @ 12,1 SAY 'SUMMARISE LOG                               S'
   @ 13,1 SAY 'UPDATE QSL STATUS                           Q'
   @ 14,1 SAY 'DISPLAY ENTRIES FOR ONE DAY                 1'
   @ 15,1 SAY 'DISPLAY LAST 20 ENTRIES IN THE LOG          E'
   @ 16,1 SAY 'DISPLAY BLOCK OF 20 ENTRIES                 B'
   @ 17,1 SAY 'DETERMINE UNIQUE CONTACTS                   U'
   @ 18,1 SAY 'TRANSFER SINGLE PX TO NEW DATABASE          X'
   @ 19,1 SAY 'DISPLAY FILES ON DISK DRIVE                 F'
   @ 20,1 SAY 'QUIT THIS MENU                              *'
   @ 22,1 SAY 'QRU'
   @ 22,5 GET task
   READ
   
   IF task = 'F'
      CLEAR
      ACCEPT 'WHICH DRIVE ? ' TO diskdrive
      diskdrive = SUBSTR(diskdrive,1,1)
      STORE diskdrive + ':' TO diskdrive
      DISPLAY Files ON &diskdrive
      RELEASE diskdrive
      WAIT
   ENDIF
   
   IF task = 'N'
      STORE 'LOG' TO LOG
      IF FILE (LOG+'.DBF')
         @ 22,1 SAY 'What is the name of the new Log file '
         STORE SUBSTR(logbook +'          ',1,10) TO logbook
         @ 22,40 GET logbook
         READ
         IF FILE (logbook+'.DBF')
            @ 22,1 SAY ' '
            ? 'ERROR, ',logbook,' ALREADY EXISTS ON DRIVE'
            WAIT
         ELSE
            @ 22,1 SAY '                                             '
            USE LOG
            COPY STRUCTURE TO &logbook
            USE &logbook
            SET TALK ON
            INDEX ON CALL+band TO &logndx
            SET TALK OFF
         ENDIF
      ELSE
         @ 22,1 SAY ' '
         ? 'ERROR, BLANK LOG FILE (log>dbf IS NOT PRESENT ON DRIVE'
         WAIT
      ENDIF
      RELEASE LOG
   ENDIF
   
   IF task = 'L'
      DO logchnge
   ENDIF
   IF FILE (logbook+'.DBF')
      IF logbook = '      '
         @ 23,1  SAY 'OPEN A LOGBOOK FIRST'
         WAIT
         STORE 'L' TO task
      ELSE
         DO CASE
         CASE task = 'S'
            DO logstat
         CASE task = 'P'
            DO logprint
         CASE task = 'H'
            DO logsrch
         CASE task = 'A'
            DO logadd
         CASE task = 'Q'
            ACCEPT 'PRINT DIRECTLY OR TO FILE (D or F) ? ' TO qtype
            IF SUBSTR(qtype,1,1) = 'D'
               DO logqsl
            ELSE
               IF SUBSTR(qtype,1,1) = 'F'
                  DO logqsl1
               ENDIF
            ENDIF
         CASE task = 'C'
            DO logcall
         CASE task = '1'
            DO logdate
         CASE task = 'E'
            USE &logbook
            GOTO BOTTOM
            IF RECNO() > 20
               SKIP -20
            ELSE
               GOTO TOP
            ENDIF
            CLEAR
            @ 2,1  SAY "    ENTRY  DATE    TIME    CALL   BAND  PWR MODE  RX  TX "
            @ 2,58 SAY "S R  COMMENTS"
            SET COLOR TO GR+/B,W+/RB,BG+
            SET COLOR TO W+/R,W+/RB,BG+
            DO WHILE .not. EOF()
               ? RECNO(),DATE,TIME,CALL,band,Power,mode,rx,tx,qslsent,qslrx,comments
               SKIP
            ENDDO
            SET COLOR TO GR+/B,W+/RB,BG+
            USE
            WAIT
            
         CASE task = 'B'
            USE &logbook
            ACCEPT 'WHAT ENTRY NUMBER ? ' TO sdate
            GOTO BOTTOM
            STORE RECNO() TO lastone
            IF &sdate >= lastone
               ?
               ? 'There are only ',lastone,' QSOs in the log'
               WAIT
            ELSE
               GOTO &sdate
               STORE '+' TO stask
               DO WHILE stask <> '*'
                  CLEAR
                  STORE 0  TO lcount
                  @ 2,1  SAY "    ENTRY  DATE    TIME    CALL   BAND  PWR MODE  RX  TX "
                  @ 2,58 SAY "S R  COMMENTS"
                  
                  SET COLOR TO W+/R,W+/RB,BG+
                  DO WHILE lcount < 20 .and. .not. EOF()
                     ? RECNO(),DATE,TIME,CALL,band,Power,mode,rx,tx,qslsent,qslrx,comments
                     
                     STORE lcount + 1 TO lcount
                     SKIP
                  ENDDO
                  SET COLOR TO GR+/B,W+/RB,BG+
                  @ 24,1 SAY 'QRU (+ - *)'
                  @ 24,15 GET stask
                  READ
                  IF stask = '-'
                     STORE RECNO() - 40 TO sdate
                     IF sdate < 1
                        STORE 1 TO sdate
                     ENDIF
                     GOTO sdate
                  ENDIF
               ENDDO
            CASE task = 'U'
               *  UNIQUE TESTS AND COUNTS UNIQUE LOG ENTRIES
               USE &logbook INDEX &logndx
               STORE 0 TO dup
               STORE 0 TO qsos
               STORE 0 TO dummy
               DO WHILE .not. EOF()
                  IF CALL = '-' .or. CALL = '.'
                     STORE dummy + 1 TO dummy
                     SKIP
                  ELSE
                     ? CALL
                     STORE qsos + 1 TO qsos
                     STORE CALL TO tcall
                     SKIP
                     DO WHILE CALL = tcall .and. .not. EOF()
                        SKIP
                        STORE dup + 1 TO dup
                     ENDDO
                     ?? qsos, dup, dummy
                  ENDIF
               ENDDO
               USE
               ?
               ?
               ?
               ? TRIM(STR(qsos,5)),' UNIQUE CALLS     ',TRIM(STR(dup,5)),'DUPLICATES, and '
               ?? TRIM(STR(dummy,5)),'DUMMY ENTRIES'
               ? 'IE. A TOTAL OF',dup + qsos + dummy,' ENTRIES IN THE LOGBOOK'
               RELEASE qsos,dup,tcall,dummy
               WAIT
               
            CASE task = 'X'
               *GETS ALL PX'S AND PUTS THEM IN FILE
               ACCEPT 'What Target Database File ? ' TO target
               ACCEPT 'What Prefix ? ' TO prefix
               SELECT 1
               USE &logbook INDEX &logndx
               IF FILE(target + '.DBF')
               ELSE
                  * CREATE IT
                  SELECT 1
                  ? 'Creating Target File Now'
                  ?
                  COPY STRUCTURE TO &target
               ENDIF
               SELECT 2
               USE &target
               SELECT 1
               FIND &prefix
               DO WHILE CALL = prefix .and. .not. EOF()
                  ? CALL,DATE,TIME,band
                  STORE DATE TO tdate
                  STORE TIME TO ttime
                  STORE CALL TO tcall
                  STORE band TO tband
                  STORE mode TO tmode
                  STORE rx TO trx
                  STORE tx TO ttx
                  STORE Power TO tpower
                  STORE qslsent TO tqslsent
                  STORE qslrx TO tqslrx
                  STORE comments TO tcomments
                  SELECT 2
                  APPEND BLANK
                  REPLACE DATE WITH tdate
                  REPLACE TIME WITH ttime
                  REPLACE CALL WITH tcall
                  REPLACE band WITH tband
                  REPLACE mode WITH tmode
                  REPLACE rx WITH trx
                  REPLACE tx WITH ttx
                  REPLACE Power WITH tpower
                  REPLACE qslsent WITH tqslsent
                  REPLACE qslrx WITH tqslrx
                  REPLACE comments WITH tcomments
                  SELECT 1
                  SKIP
               ENDDO
               USE
               SELECT 2
               ? 'Stand by while database is indexed'
               SET TALK ON
               INDEX ON CALL+ band TO &target
               SET TALK OFF
               USE
               RELEASE tdate,ttime,tcall,tband,tmode,trx,ttx
               RELEASE tpower,tqslsent,tqslrx,tcomments,target,prefix
               
            ENDIF
            RELEASE lastone,stask,sdate,lcount
            USE
            
         ENDCASE
      ENDIF
   ELSE
      @ 22,1 SAY ' '
      ? 'ERROR, ',logbook, 'IS NOT PRESENT ON DRIVE'
      WAIT
   ENDIF
ENDDO
USE
STORE ' ' TO task
RETURN
*: EOF: LOGFUNCT.PRG
