*:*********************************************************************
*:
*:        Program: LOGCALL.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 04/23/89     15:25
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:           Uses: &LOGBOOK.DBF   
*:
*:        Indexes: &LOGNDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* LOGCALL THIS PROGRAM PRINTS A LOG IN CALL ORDER   VER 890422
* copyright Joe Kasser G3ZCZ 1984 - 1989
* program to print logbook
* called from LOGBOOK

* STRUCTURE FOR FILE:  B:LOG     .DBF
* FLD       NAME      TYPE WIDTH   DEC
* 001     DATE         C    008
* 002     TIME         C    004
* 003     BAND         C    003
* 004     CALL         C    010
* 005     RX           C    003
* 006     TX           C    003
* 007     MODE         C    004
* 008     POWER        C    004
* 009     QSLSENT      C    001
* 010     QSLRX        C    001
* 011     COMMENTS     C    010

STORE ' ' TO df
ACCEPT 'Do you want hard copy (Y/N) ?' TO df
df = UPPER(df)
IF df = 'Y'
   SET PRINT ON
ENDIF

STORE 60 TO linecount
STORE 1 TO pagecount
linecount = INT(linecount)
pagecount = INT(pagecount)

USE &logbook
GOTO BOTTOM
IF (EOF() .or. BOF())
   ? 'LOGBOOK IS EMPTY'
ELSE
   STORE DATE TO tdate
   SET INDEX TO &logndx
   GOTO TOP
   DO WHILE .not. EOF()
      IF linecount > 55
         IF df = 'Y'
            EJECT
         ENDIF
         ? 'INDEXED LOGBOOK PRINTOUT  '
         ?? callsign,'   as of ',tdate,'   PAGE ',pagecount
         STORE pagecount + 1 TO pagecount
         ?
         ?
         ? ' CALL        DATE   TIME BND RX  TX  MODE PWR  S R  COMMENTS'
         ? '--------------------------------------------------------------------'
         STORE 3 TO linecount
      ENDIF
      *   now print entries
      ? CALL,DATE,TIME,band,rx,tx,mode,Power,qslsent,qslrx,comments
      STORE linecount + 1 TO linecount
      SKIP
   ENDDO
   USE
   IF df = 'Y'
      EJECT
      SET PRINT OFF
   ELSE
      ?
      WAIT
   ENDIF
ENDIF
RELEASE df,linecount,pagecount,tdate
RETURN
*: EOF: LOGCALL.PRG
