*:*********************************************************************
*:
*:        Program: LOGADD.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 05/04/90     12:53
*:
*:      Called by: LOGFUNCT.PRG                  
*:
*:           Uses: &LOGBOOK.DBF   
*:
*:        Indexes: &LOGNDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
* IF YOU CHANGE THE STRUCTURE OF THE DATABASE TO INCREASE THE
*WIDTH OF THE COMMENTS, MODIFY THE PROGRAM AS SHOWN BELOW

ACCEPT 'Are you running this in real TIME (Y/N) ? ' TO rtf
IF rtf = 'Y'
   STORE '9999' TO otime
   STORE ' ' TO dummy
ENDIF

USE &logbook
STORE .t. TO callflag
GOTO BOTTOM
STORE CALL TO lastcall
STORE RECNO() TO lastentry

*initialise new variables
STORE DATE TO ndate
STORE TIME TO ntime
STORE band TO nband
STORE Power TO npower
STORE mode TO nmode
STORE rx TO nrx
STORE tx TO ntx

SET INDEX TO &logndx
CLEAR
*MAIN LOOP
DO WHILE callflag
   STORE "-" TO nqslsent
   STORE "-" TO nqslrx
   STORE "          " TO ncall
   * CHANGE THE LENGTH OF THE SPACES BETWEEN THE " " ON THE NEXT LINE
   * IF YOU CHANGE THE WIDTH OF THE COMMENTS here it is set to 10
   STORE "          " TO ncomments
   STORE " " TO logflag
   STORE .t. TO dataflag
   
   DO WHILE dataflag
      USE &logbook
      GOTO BOTTOM
      IF RECNO() > 14
         SKIP -14
      ELSE
         GOTO TOP
      ENDIF
      CLEAR
      SET COLOR TO W+/R,W+/RB,BG+
      @ 1,21  SAY 'PREVIOUS ENTRIES IN LOG, ARE'
      ?
      @ 3,1  SAY "    ENTRY  DATE    TIME    CALL   BAND  PWR MODE  RX  TX "
      @ 3,58 SAY "S R  COMMENTS"
      SET COLOR TO GR+/B,W+/RB,BG+
      
      DO WHILE .not. EOF()
         ? RECNO(),DATE,TIME,CALL,band,Power,mode,rx,tx,qslsent,qslrx,comments
         SKIP
      ENDDO
      SET INDEX TO &logndx
      IF rtf = 'Y'
         *      DO REALTIME
         ntime = TIME()
         ndate = DTOC(DATE())
         ndate = SUBSTR(ndate,7, 2) + '/' + SUBSTR(ndate,1,5)
         ntime = SUBSTR(ntime,1,2) + SUBSTR(ntime,4,2)
      ENDIF
      *      @ 19,1  SAY lastentry
      *      @ 19,12 SAY "LAST CONTACT WAS WITH "
      *      @ 19,35 SAY lastcall
      
      @ 21,3  SAY "DATE    TIME    CALL   BAND  PWR MODE  RX  TX"
      @ 21,49 SAY "S R  COMMENTS"
      @ 23,1  SAY "QRU (*THL)"
      
      @ 22,1  GET ndate
      @ 22,11 GET ntime
      @ 22,16 GET ncall
      @ 22,27 GET nband
      @ 22,31 GET npower
      @ 22,36 GET nmode
      @ 22,41 GET nrx
      @ 22,45 GET ntx
      @ 22,49 GET nqslsent
      @ 22,51 GET nqslrx
      @ 22,53 GET ncomments
      @ 23,13 GET logflag
      READ
      
      DO CASE
      CASE logflag = 'H'
         GOTO TOP
         STORE 1 TO linecount
         IF SUBSTR(ncall,1) <> ' '
            STORE TRIM(ncall) TO fcall
            FIND &fcall
            IF (EOF() .or. BOF())
               CLEAR
               SET COLOR TO W+/R,W+/RB,BG+
               @ 5,1 SAY ncall
               @ 5,12 SAY "Does not appear to be in the log"
               WAIT
               CLEAR
               SET COLOR TO GR+/B,W+/RB,BG+
            ELSE
               DO WHILE  CALL = fcall .and. (.not. EOF())
                  IF linecount = 1
                     CLEAR
                     SET COLOR TO W+/R,W+/RB,BG+
                     @ 1,21  SAY 'PREVIOUS ENTRIES IN LOG, ARE'
                     
                     @ 3,1  SAY "    ENTRY  DATE    TIME    CALL   BAND  PWR MODE  RX  TX "
                     @ 3,58 SAY "S R  COMMENTS"
                     SET COLOR TO GR+/B,W+/RB,BG+
                  ENDIF
                  ? RECNO(),DATE,TIME,CALL,band,Power,mode,rx,tx,qslsent,qslrx,comments
                  
                  STORE linecount + 1 TO linecount
                  IF linecount = 20
                     ?
                     WAIT
                     STORE 1 TO linecount
                  ENDIF
                  SKIP
               ENDDO
               ?
               WAIT
               IF linecount > 16
                  CLEAR
               ENDIF
            ENDIF
         ELSE
            ? 'ERROR Blank Call'
         ENDIF
         
      CASE  logflag = 'L'
         *LOG ENTRY
         APPEND BLANK
         STORE .F. TO dataflag
         REPLACE qslsent WITH nqslsent
         REPLACE qslrx WITH nqslrx
         REPLACE DATE WITH ndate
         REPLACE TIME WITH ntime
         REPLACE CALL WITH ncall
         REPLACE band WITH nband
         REPLACE Power WITH npower
         REPLACE mode WITH nmode
         REPLACE rx WITH nrx
         REPLACE tx WITH ntx
         REPLACE comments WITH ncomments
         STORE CALL TO lastcall
         STORE RECNO() TO lastentry
         STORE "          " TO ncall
         STORE "          " TO ncomments
         
      CASE logflag = "*"
         STORE .F. TO callflag
         STORE .F. TO dataflag
         
      CASE logflag = 'T'
         IF rtf = 'Y'
            ndate = DTOC(DATE())
            ndate = SUBSTR(ndate,7, 2) + '/' + SUBSTR(ndate,1,5)
            ntime = TIME()
            ntime = SUBSTR(ntime,1,2) + SUBSTR(ntime,4,2)
         ENDIF
         @ 22,1 SAY ndate
         @ 22,11 SAY ntime
      ENDCASE
      *      ENDIF
   ENDDO
ENDDO
USE
* GET READY TO EXIT
RELEASE lastcall,lastentry,ndate,ntime,ncall,nband,npower,nmode
RELEASE nqslsent,nqslrx,nrx,ntx,ncomments,fcall,linecount,fdate
RELEASE otime,rtf,mtime,cpointer,dummy,hour,MIN,mm,dd,yy,ndate
RELEASE callflag,dataflag,logflag
RETURN
*: EOF: LOGADD.PRG
