*:*********************************************************************
*:
*:        Program: LOG2DBF.PRG
*:
*:         System: PC-HAM Logbook
*:         Author: Joe Kasser G3ZCZ
*:      Copyright (c) 1990, Joe Kasser
*:  Last modified: 12/24/87     23:31
*:
*:      Called by: LOGMISCF.PRG                  
*:
*:           Uses: &LOG           
*:               : &CONTESTLOG.DBF
*:               : &OLDLOG        
*:               : &LOGBOOK.DBF   
*:
*:        Indexes: &CONTESTLOG
*:               : &LOGNDX
*:
*:      Documented 05/04/90 at 13:49                SNAP!  version 3.12f
*:*********************************************************************
*LOG2DBF CONVERTS A BASIC LOG FILE TO A DATABASE VERSION 851114
* Modified 871120
STORE 'LOG' TO LOG
IF FILE (LOG + '.DBF')
   USE &log
   * EMPTY LOG FILE
   
   STORE ' ' TO contestlog
   ACCEPT 'What is the name of the contest log (D:NAME) ' TO contestlog
   IF FILE (contestlog + '.DBF')
      ? 'ERROR,',contestlog,' ALREADY EXISTS'
      WAIT
   ELSE
      IF FILE (contestlog+'.LOG')
         COPY STRUCTURE TO &contestlog
         ?
         ? ' New database file created'
         USE &contestlog
         STORE TRIM(contestlog) + '.LOG' TO oldlog
         ?
         ? 'Copying log data now'
         SET TALK ON
         APPEND  FROM &oldlog DELIM
         SET TALK OFF
         STORE ' ' TO df
         ACCEPT ' Do you want a listing of the database (Y/N) ? ' TO df
         IF UPPER(df) = 'Y'
            LIST
            ?
         ENDIF
         ?
         
         ACCEPT 'Do you want the contacts numbered (Y/N) ? ' TO df
         IF UPPER(df) = 'Y'
            STORE 1 TO qsocount
            GOTO TOP
            DO WHILE .not. EOF()
               REPLACE rx WITH SUBSTR(comments,1,3)
               REPLACE comments WITH SUBSTR(comments,4,10)
               IF UPPER(df) = 'Y'
                  STORE STR(qsocount,10) TO number
                  DO WHILE SUBSTR(number,1,1) = ' '
                     STORE SUBSTR(number,2,10) TO number
                  ENDDO
                  REPLACE comments WITH TRIM(number)+'-'+comments
                  STORE qsocount + 1 TO qsocount
               ENDIF
               DISP
               SKIP
            ENDDO
         ENDIF
         
         ACCEPT 'Do you want to INDEX the contest log (DBF) (Y/N) ? ' TO df
         IF UPPER(df) = 'Y'
            ?
            USE &contestlog
            SET TALK ON
            INDEX ON CALL+band TO &contestlog
            SET TALK OFF
            ? 'TO PRINT CONTEST LOG, go back to main menu'
            ?
            ? 'SET LOG TO contestlog, AND PRINT IT'
            WAIT
         ENDIF
         
         ACCEPT 'Append the new log to the main logbook (Y/N) ? ' TO df
         IF UPPER(df) = 'Y'
            ?
            IF FILE (logbook + '.DBF')
               USE &logbook INDEX &logndx
               SET TALK ON
               APPEND FROM &contestlog
               SET TALK OFF
            ELSE
               ? 'ERROR,',logbook,' IS NOT ON DEFAULT DRIVE'
               WAIT
            ENDIF
         ENDIF
         
         ACCEPT 'Do you want to make the contest log the default log ? ' TO df
         IF UPPER(df) = 'Y'
            STORE contestlog TO logbook
            STORE contestlog TO logndx
         ENDIF
      ELSE
         ? 'ERROR CONTEST LOG IS NOT ON DEFAULT DRIVE'
         WAIT
      ENDIF
   ENDIF
ELSE
   ? 'BLANK LOG IS NOT ON DEFAULT DRIVE'
   WAIT
ENDIF
RELEASE oldlog,df,contestlog,LOG
USE
RETURN
*: EOF: LOG2DBF.PRG
