/*****************************************************************************
*                                                                            *
*  GhostLib Assistant by GhostWare                                           *
*  Copyright (c) 1994  -  all rights reserved                                *
*                                                                            *
*  File : GW_CONFG.S                                                         *
*                                                                            *
*  Description :                                                             *
*  Macro for confuguring GhostLib Assistant                                  *
*                                                                            *
*  Date/time : 14-06-94 21:14                                                *
*                                                                            *
*****************************************************************************/
macro_file GW_CONFG;

#include GHOST.GWH

/* ---------------------------------------------------------------------------- */
/* GWConfig - Evolve Configuration Macro                                        */
/* ---------------------------------------------------------------------------- */
macro GWConfig from edit{

int iCurrWinId, iNewWinId, lOldInsMode = insert_mode,
		iKey1, iKey2, iHelp, lOldRefresh = refresh;

str sKey;

refresh = false;
insert_mode = True;

set_global_int('GWIINT_1', global_int('!GWScreenSaver'));
set_global_str('GWISTR_1', 'No screensaver()Blank screen()Column Drop and Float()Time Saver()WhirlPool()');
set_global_str('GWIPARM_1','/T=screensaver Name          :/C=2/W=25/L=1/TP=3/QK=13');

set_global_int('GWIINT_2', global_int('!GWSaverDelay'));
set_global_str('GWIPARM_2','/T=sCreensaver delay seconds :/C=2/W=4/L=2/TP=1/QK=2');

set_global_int('GWIINT_3', global_int('!GWPosEOLComment'));
set_global_str('GWIPARM_3','/T=EOL comment position      :/C=2/W=4/L=3/TP=1/QK=1');

set_global_int('GWIINT_4',global_int('!GWAssistantKey'));
set_global_str('GWIPARM_4','/T=Assistant key assignment  :/C=2/W=15/L=4/QK=1/TP=9/R=11/M=1');

set_global_str('GWIPARM_5','/T= Save '+GW_FULLNAME+' configuration /C=8/L=6/QK=2/TP=11/R=5');

rm('UserIn^Data_In /X=10/W=61/PRE=GW/S=1/#=5/T= '+GW_FULLNAME+' configuration ');

if(return_int) {
	// Save changed values to the gloval variables
	set_global_int('!GWScreenSaver',   global_int('GWIINT_1'));
	set_global_int('!GWSaverDelay',    global_int('GWIINT_2'));
	set_global_int('!GWPosEOLComment', global_int('GWIINT_3'));
	set_global_int('!GWAssistantKey',  global_int('GWIINT_4'));

	if (return_int == 5) {;              // Save configuration
		put_box(20, 5, 65, 10, 0, m_h_color,' '+GW_FULLNAME+' configuration ', True);
		write('Saving configuration......', 29, 7, 0, m_h_color);
		iCurrWinId = window_id;            // Save the current window Id
		refresh = False;                   // Suppress the screen, so you don't see what happens
		switch_window( window_count );     // Go to the last window
		create_window;                     // Create a new window for config file
		iNewWinId = window_id;             // Get the Id of the new window
		return_str = 'GWCFG' + user_id + '.S';  // Config File name
		rm('MakeUserPath');                // Makes complete path and filename for the current USER_ID (in MESYS.S)
		file_name = return_str;
		call WriteLines;                   // Write the lines to the config file
		save_file;                         // Save the config file
		return_str = me_path+'CMAC -P'+me_path+'\mac\ '+truncate_extension(file_name)+' >NUL';
		delete_window;                     // Delete the config file window
		switch_win_id(iCurrWinId);         // Go back to current window
		write('Compiling configuration......', 28, 7, 0, m_h_color);
		rm('MeUtil1^Exec /CMD=1/SCREEN=0/SWAP=0/MEM=0');
		del_file(user_id + 'MEERR.TMP');   // Delete the error file
		kill_box;

		rm('Ghost^GWInit');                // Initialize GhostLib Assistant
		make_message(GW_FULLNAME+' configuration is changed!');
		};
  } else {                             // Save configuration NOT selected
		make_message(GW_FULLNAME+' configuration is NOT changed!');
  };
goto exit;

WriteLines:
	// Write commands to the macro configuration file
	text('//----------------------------------------------------------------------------'); cr;
	text('//'); cr;
	text('//  '+GW_FULLNAME+' configuration macro'); cr;
	text('//'); cr;
	text('//  by GhostWare'); cr;
	text('//'); cr;
	text('//  Copyright (c) '+GW_COPYRIGHTYEAR+' -  All rights reserved'); cr;
	text('//'); cr;
	text('//  Date/time : '+Date+' '+Time); cr;
	text('//'); cr;
	text('//----------------------------------------------------------------------------'); cr;
  text('MACRO GWCFG' + user_id + ' DUMP {'); cr; // Start of the macro
	cr;

  text('//----------------------//'); cr;
  text('// Set global variables //'); cr;
  text('//----------------------//'); cr; cr;
  text('// GWScreenSaver      : 1 = No screensaver'); cr;
  text('//                      2 = Blank screen'); cr;
  text('//                      3 = Column Drop and Float'); cr;
  text('//                      4 = Time Saver'); cr;
  text('//                      5 = Whirlpool'); cr;
  text('set_global_int(''!GWScreenSaver'',   '+str(global_int('!GWScreenSaver')) + ');'); cr; cr;
  text('// GWSaverDelay       : Number of seconds before the screensaver is activated'); cr;
	text('set_global_int(''!GWSaverDelay'',    '+str(global_int('!GWSaverDelay')) + ');'); cr; cr;
  text('// GWPosEOLComment    : Column position for End Of Line comments'); cr;
	text('set_global_int(''!GWPosEOLComment'', '+str(global_int('!GWPosEOLComment')) + ');'); cr; cr;
  text('// GWAssistantKey     : Numeric value of the Assistant Key'); cr;
	text('set_global_int(''!GWAssistantKey'',  '+str(global_int('!GWAssistantKey')) + ');'); cr; cr;
	// Determine the assistant key name
	iHelp = global_int('!GWAssistantKey'); // The desired keycode
	iKey1 = iHelp % 256;                   // Calculate KEY1 value
	iKey2 = (iHelp - iKey1) / 256;         // Calculate KEY2 value
  RM('MakeKey /K1='+Str(iKey1)+'/K2='+Str(iKey2));  // Determine key name (in KEYCODES.S)
	sKey = Return_Str;                     // The keyname e.g. <F2>
  text('// GWNameAssistantKey : Name of the Assistant Key'); cr;
	text('set_global_str(''!GWNameAssistantKey'', '''+sKey+''');'); cr; cr;

  text('//----------------------------------------------//'); cr;
  text('// Assign the GhostLib Assistant macro to a key //'); cr;
  text('//----------------------------------------------//'); cr;
	text('macro_to_key('+sKey+', ''GW_EXPND^GWAssist'', edit);'); cr;
	// Determine the FKEY label number for flabel()
  if( ((xpos('SHFT',caps(sKey),1))) ) {;
    iHelp = iKey2 - 73;
  } else if( ((xpos('CTRL',caps(sKey),1))) ) {;
    iHelp = iKey2 - 73;
  } else if( ((xpos('ALT',caps(sKey),1))) ) {;
    iHelp = iKey2 - 73;
  } else {
    iHelp = iKey2 - 58;
  };
  text('flabel(''GWLib '', '+str(iHelp)+ ', 0);'); cr;
  text('};'); cr;                      // End of macro file
	ret;

Exit:
	// Remove globals
	for( iHelp = 1; iHelp <= 5; iHelp++ ) {
		set_global_int('GWIINT_' + str(iHelp), 0 );
		set_global_str('GWISTR_' + str(iHelp), '' );
		set_global_str('GWPARM_' + str(iHelp), '' );
	};
	// Restore previous states
	insert_mode = lOldInsMode;
	refresh = lOldRefresh;
};
