/*Graffiti Wall v2.6 by John Waters*/

parse arg UNAME','ALIAS','ACCESS','GFX','ASK .
if compress(GFX) = '' then GFX = 'MONO'

if ~show('L',"rexxsupport.library") then do
   if addlib('rexxsupport.library',0,-30,0) then
      nop
   else do
      say 'Support library not available.'
      exit 10
      end
end

signal on BREAK_C
signal on FAILURE
signal on SYNTAX

if upper(GFX)='MONO' then do
   BLK='';RED=''
   GRN='';YEL=''
   BLU='';PUR=''
   CYA='';WHT=''
   BLURED='';REDWHT=''
   BLUBAK='';REDBAK=''
   REDBLU='';OFF='';CLS=''
end
else do
   BLK='[1;30m';RED='[1;31m'
   GRN='[1;32m';YEL='[1;33m'
   BLU='[1;34m';PUR='[1;35m'
   CYA='[1;36m';WHT='[1;37m'
   BLURED='[1;34;41m';REDWHT='[1;41;37m'
   BLUBAK='[1;44m';REDBAK='[1;41m'
   REDBLU='[1;31;44m';OFF='[0m';CLS='[H[J'
end

if upper(ASK) ~= 'NOASK' then do
   Say CLS
   Say ''
   call GetInput(RED'Read the Graffiti Wall ('YEL'Y'RED'/n)? 'OFF,1)
   if upper(Ans)='N' then signal EndPro
end

MultiSpray = 1      /* MultiSpray? 1=ON 0=OFF                              */
AliasQ     = 1      /* Let users use aliases? 1=YES 0=NO                   */
SysAcc     = 255    /* Sysop access level                                  */
Lines      = 10     /* Number of Graffiti Wall Lines                       */
NoAcc      = N      /* Will not let this access or lower spray on the wall */
                    /* Set to 'N' if you don't want an access limit        */
FileDir = 'Doors:'  /* Change this if you are using a different directory  */
DirName = 'Wall'    /* Name of Graffiti Wall directory                     */
File    = 'GWall'   /* Name of Graffiti Wall data file                     */

PKNclr = 1
PKMclr = 1
RdWall = 0
Col    = 74

if ~exists(FileDir||DirName) then do
    makedir(FileDir||DirName)
end
if ~exists(FileDir||DirName'/'||File) then do
   do i=1 to Lines
      Ran=Random(1,6,Time('s'))
      if Ran=1 then c.i='[1;31m'
      if Ran=2 then c.i='[1;32m'
      if Ran=3 then c.i='[1;33m'
      if Ran=4 then c.i='[1;35m'
      if Ran=5 then c.i='[1;36m'
      if Ran=6 then c.i='[1;37m'
   end
   call open(File,FileDir||DirName'/'||File,'W')
   do i=1 to Lines
      call writeln(File,c.i)
      call writeln(File,c.i)
      call writeln(File,'NONE')
      call writeln(File,'John Waters')
      call writeln(File,'The Graffiti Wall v2.6')
   end
   call close(File)
end

call ReadWall

Read:
  Say CLS
  do i=1 to Lines
     if Alias.i ~= 'NONE' then do
        if Access>=SysAcc then RName.i='('Name.i')'
        else RName.i=''           
        Name.i=Alias.i
     end
     else Rname.i=''
     if upper(GFX)='MONO' then do
        Ncolor.i=''
        Mcolor.i=''
     end
     Say Ncolor.i||Name.i RName.i
     Say '     'Mcolor.i||BLUBAK||left(Message.i,col)OFF
  end
  if (RdWall) then do
     call GetInput('Hit any key ',1)
     Signal Choices
  end
  RdWall=1
  if upper(NoAcc)='N' then Signal LastPerson
  if Access<=NoAcc then do
     call GetInput('Hit any key ',1)
     signal EndPro
  end

LastPerson:
  LastPerson=Name.Lines
  if upper(LastPerson)=upper(UNAME) then do
     if (MultiSpray) then Signal Ask
     call GetInput('Hit any key ',1)
     signal EndPro
  end

Ask:
  Say ''
  Call GetInput(PUR'Spray on the wall (y/'GRN'N'PUR')? 'OFF,1)
  if upper(Ans)='Y' then Signal Input
  signal EndPro

Input:
  Say ''
  Say CYA'  Spray can ready.  Go for it.'
  Say GRN'<------------------------------------------------------------------------->'OFF
  Call GetInput('>'OFF,col)
  umessage = Ans
  if compress(umessage)='' then signal EndPro
  if (AliasQ) then do
     Say ''
     Call GetInput(BLU'Would you like to use an Alias (y/'YEL'N'BLU')? 'OFF,1)
     if upper(Ans)='Y' then do
        Say ''
        Say GRN'What would you like your Alias to be?'
        Call GetInput(BLU'['RED||Alias||BLU']> 'OFF,50)
        Alias2=Ans
        if compress(alias2)='' then Alias2=Alias
        Signal Choices
     end 
  end
  Alias2 = 'NONE'

Choices:
  Say CLS
  Say ''
  Say '              'WHT' ___________________________________________________ 'OFF
  Say '              'REDWHT'|___|___|___|___|___|___|___|___|___|___|___|___|___|'OFF
  Say '              'REDWHT'|_|___|___|___|_'GRN'The_Graffitit_Wall_v2.6'WHT'___|___|___|_|'OFF
  Say '              'REDWHT'|___|___|___|___|___'YEL'By_John_Waters'WHT'__|___|___|___|___|'OFF
  Say '              'REDWHT'|_|___|___|___|___|___|___|___|___|___|___|___|___|_|'OFF
  Say '              'REDWHT'|___|'BLU'['CYA'R'BLU']'CYA'estart_Your_Message'WHT'_|_'BLU'['CYA'V'BLU']'CYA'iew_Your_Message'WHT'___|'OFF
  Say '              'REDWHT'|_|__'BLU'['CYA'L'BLU']'CYA'ook_At_Wall'WHT'___|___|___'BLU'['CYA'A'BLU']'CYA'bort_Your_Message'WHT'|_|'OFF
  if upper(GFX)~='MONO' then do
     Say '              'REDWHT'|___|'BLU'['CYA'N'BLU']'CYA'ame_Color'WHT'___|___|___|_'BLU'['CYA'M'BLU']'CYA'essage_Color'WHT'___|___|'OFF
     Say '              'REDWHT'|_|___|___|___|___|___|___|___|___|___|___|___|___|_|'OFF
  end
  Say '              'REDWHT'|___|___|___|___|___|___|___|___|___|___|___|___|___|'OFF
  Call GetInput('              'BLU'['GRN'Return To Save'BLU'] 'PUR'Pick One: 'OFF,1)
  if upper(Ans) = 'R' then Signal Input
  if upper(Ans) = 'L' then Signal Read
  if upper(Ans) = 'M' then Signal PickMessageColor
  if upper(Ans) = 'N' then Signal PickNameColor
  if upper(Ans) = 'A' then Signal EndPro
  if upper(Ans) = 'V' then Signal View
  Signal Spray

View:
  call color
  if Alias2 ~= 'NONE' then uname1=Alias2
  else uname1=uname
  Say CLS
  if upper(GFX)='MONO' then do 
     Ncolor1=''
     Mcolor1=''
  end
  else do
     Ncolor1=Ncolor
     Mcolor1=Mcolor
  end
  Say Ncolor1||uname1
  Say '     'Mcolor1||BLUBAK||left(umessage,col)OFF
  Say ''
  call GetInput('Hit any key ',1)
  Signal Choices

PickNameColor:
  PKNclr='0'
  Say CLS
  Say ' '
  Say '[1] - 'GRN'Green'
  Say '[2] - 'CYA'Cyan'
  Say '[3] - 'PUR'Purple'
  Say '[4] - 'YEL'Yellow'
  Say '[5] - 'RED'Red'
  Say '[6] - 'WHT'White'
  Say '[7] - 'BLU'Blue'OFF
  Say ''
  Call GetInput(BLU'Pick One (1-7)>'OFF,1)
  if upper(Ans)='1' then NColor='[1;32m'
  if upper(Ans)='2' then NColor='[1;36m'
  if upper(Ans)='3' then NColor='[1;35m'
  if upper(Ans)='4' then NColor='[1;33m'
  if upper(Ans)='5' then NColor='[1;31m'
  if upper(Ans)='6' then NColor='[1;37m'
  if upper(Ans)='7' then NColor='[1;34m'
  if Ans <1 | Ans >7 then Signal PickNameColor
  Signal Choices

PickMessageColor:
  PKMclr='0'
  Say CLS
  Say ' '
  Say '[1] - 'BLUBAK''GRN'Green 'OFF
  Say '[2] - 'BLUBAK''CYA'Cyan  'OFF
  Say '[3] - 'BLUBAK''PUR'Purple'OFF
  Say '[4] - 'BLUBAK''YEL'Yellow'OFF
  Say '[5] - 'BLUBAK''RED'Red   'OFF
  Say '[6] - 'BLUBAK''WHT'White 'OFF
  Say '[7] - 'BLUBAK''BLK'Black 'OFF
  Say ' '
  Call GetInput(BLU'Pick One (1-7)>'OFF,1)
  if upper(Ans)='1' then MColor='[1;32m'
  if upper(Ans)='2' then MColor='[1;36m'
  if upper(Ans)='3' then MColor='[1;35m'
  if upper(Ans)='4' then MColor='[1;33m'
  if upper(Ans)='5' then MColor='[1;31m'
  if upper(Ans)='6' then MColor='[1;37m'
  if upper(Ans)='7' then MColor='[1;30m'
  if Ans <1 | Ans >7 then Signal PickMessageColor
  Signal Choices

Spray:
  InUse = GETCLIP('gwall')
  If InUse = 'busy' then signal Spray
  call SETCLIP('gwall','busy')
  call color
  call ReadWall
  call open(File,FileDir||DirName'/'||File,'W')
  do i = 2 to Lines
     call writeln(File,Ncolor.i)
     call writeln(File,Mcolor.i)
     call writeln(File,alias.i)
     call writeln(File,name.i)
     call writeln(File,message.i)
  end
  call writeln(File,Ncolor)
  call writeln(File,Mcolor)
  call writeln(File,alias2)
  call writeln(File,uname)
  call writeln(File,umessage)
  call close(File)
  signal EndPro

ReadWall:
  call open(File,FileDir||DirName'/'||File,'R')
  do i=1 to Lines
     Ncolor.i=readln(File)
     Mcolor.i=readln(File)
     Alias.i=readln(File)
     Name.i=readln(File)
     Message.i=readln(File)
  end
  call close(File)
  return

Color:
  if (PKMclr) then do
     Ran=Random(1,7,Time('s'))
     if Ran=1 then Mcolor='[1;30m'
     if Ran=2 then Mcolor='[1;31m'
     if Ran=3 then Mcolor='[1;32m'
     if Ran=4 then Mcolor='[1;33m'
     if Ran=5 then Mcolor='[1;35m'
     if Ran=6 then Mcolor='[1;36m'
     if Ran=7 then Mcolor='[1;37m'
  end
  if (PKNclr) then do
     Ran=Random(1,7,Time('s'))
     if Ran=1 then Ncolor='[1;31m'
     if Ran=2 then Ncolor='[1;32m'
     if Ran=3 then Ncolor='[1;33m'
     if Ran=4 then Ncolor='[1;34m'
     if Ran=5 then Ncolor='[1;35m'
     if Ran=6 then Ncolor='[1;36m'
     if Ran=7 then Ncolor='[1;37m'
  end
  return

break_c:
error:
failure:
SYNTAX:
  Say ''
  Say '*Hmmm, Looks like we got an Error in the Graffiti Wall.*'
  Say '*Please tell the Sysop.*'
  Say '*Line:' SIGL '   Error Code:' RC'*'
  signal EndPro

GetInput:
  parse arg Question,Len
  Ans=''
  call writech(stdout,Question)
  do i = 1 to Len until char = '0d'x
     char = readch(stdin,1)
     call writech(stdout,char)
     Ans = Ans||char
     if char == '08'x then do
        if ans=='08'x then do
           writech(stdout,' ')
           i=i-1
           Ans=left(ans,length(ans)-1)
        end
        else do
           writech(stdout,' '||'08'x)
           i=i-2
           Ans=left(ans,length(ans)-2)
        end
     end
  end
  if ans='0d'x then say
  if right(ans,1)='0d'x then ans=left(ans,length(ans)-1)
  Return

EndPro:
  call SETCLIP('gwall')
  Say OFF
  exit
