(**********************************************************************
:Program.    WBDemo.mod
:Contents.   guitools.library demonstration
:Author.     Carsten Ziegeler
:Address.    Augustin-Wibbelt-Str.7, 33106 Paderborn
:Phone.      05254/67439
:Copyright.  Freeware, refer to GUITools-Documentation
:Language.   Modula-2
:Translator. M2Amiga V4.1
:Remark.     OS 2.0 required
:Remark.     requires guitools.library V38.0
:History.    v1.1  Carsten Ziegeler  09-Feb-94
***********************************************************************)
MODULE WBDemo;

  FROM SYSTEM     IMPORT ADR, ADDRESS, ASSEMBLE, TAG;
  FROM ExecD      IMPORT MemReqs, MemReqSet, Node, NodePtr, MinList;
  FROM ExecL      IMPORT AllocMem, FreeMem, RemTail, Insert;
  FROM GadToolsD  IMPORT buttonKind, listviewKind, GtTags, NewGadgetFlagSet,
                         NewGadgetFlags;
  FROM IntuitionD IMPORT WindowPtr, WindowFlagSet, WindowFlags, IDCMPFlagSet,
                         IDCMPFlags, WaTags;

  FROM GUIToolsD  IMPORT GUIInfoPtr, GUIInfoFlagSet, GUIInfoFlags, guiSet,
                         GuiTags, preserve, bevelboxKind, SgTags, okReqKind,
                         progressIndicatorKind;
  FROM GUIToolsL  IMPORT OpenIntWindowTags, CloseIntWindow, CreateGUIInfoTags,
                         CreateGadget, CreateGadgetFull, SetProcessWindow,
                         CreateGadgetText, SetGUI, WaitIntMsg, TopazAttr,
                         ResizeGadget, RedrawGadgets, CreateSpecialGadget,
                         SimpleReqP, ModifyGadget, RemoveGadgets, ClearWindow;

CONST version = ADR('WBDemo 1.1 (09.02.94)\n');

TYPE ListViewArr = ARRAY[0..9] OF ADDRESS;

CONST listviewALabs = ListViewArr{ADR('Amiga 500'), ADR('Amiga 500+'),
                       ADR('Amiga 600'), ADR('Amiga 1000'),
                       ADR('Amiga 1200'), ADR('Amiga 2000'),
                       ADR('Amiga 3000'), ADR('Amiga 4000/030'),
                       ADR('Amiga 4000/040'), ADR('Amiga XXXX/yyy')};
      listviewCLabs = ListViewArr{ADR('2086'), ADR('80286'),
                       ADR('80386'), ADR('80486'),
                       ADR('Pentium'), ADR('MC 68000'),
                       ADR('MC 68020'), ADR('MC 68030'),
                       ADR('MC 68040'), ADR('MC 68060')};

VAR win : WindowPtr;
    oldWin : WindowPtr;
    gui : GUIInfoPtr;
    tagbuf : ARRAY[0..19] OF LONGCARD;

    innerWidth, innerHeight : INTEGER;
    prg : INTEGER;

    alist,
    clist  : MinList;        (* Lists for ListviewKind-Gadget *)

  (* Creates two exec.lists. One contains some amiga-models and the other
     some cpu-kinds ! *)
  PROCEDURE CreateLists;
  VAR entry  : NodePtr;
      i      : CARDINAL;
  BEGIN
    (* Init amiga-list & cpu-list/ same as NewList(ADR(...)) *)
    ASSEMBLE(LEA     alist(A4), A0
             MOVE.L  A0,(A0)
             ADDQ.L  #4,(A0)
             CLR.L   4(A0)
             MOVE.L  A0,8(A0)
             LEA     clist(A4), A0
             MOVE.L  A0,(A0)
             ADDQ.L  #4,(A0)
             CLR.L   4(A0)
             MOVE.L  A0,8(A0)
    END);
    FOR i := 0 TO 9 DO     (* make the list-entries *)
      entry := AllocMem(SIZE(Node), MemReqSet{memClear});
      IF entry # NIL THEN
        entry^.name := listviewALabs[i];
        Insert(ADR(alist), entry, NIL);
      END;
      entry := AllocMem(SIZE(Node), MemReqSet{memClear});
      IF entry # NIL THEN
        entry^.name := listviewCLabs[i];
        Insert(ADR(clist), entry, NIL);
      END;
    END;
  END CreateLists;


BEGIN
  CreateLists;
  win := OpenIntWindowTags( 50, 50, 300, 150, ADR('WB-Demo'),
                            IDCMPFlagSet{gadgetUp, closeWindow, newSize,
                                         refreshWindow, vanillaKey,
                                         gadgetDown},
                            WindowFlagSet{activate, windowSizing,
                                          windowDepth, windowClose,
                                          windowDrag}, NIL,
                            TAG(tagbuf, waMinWidth, 250,
                                        waMinHeight,120,
                                        waMaxWidth, 500,
                                        waMaxHeight,200, NIL));
  IF win # NIL THEN
    oldWin := SetProcessWindow(win);
    gui := CreateGUIInfoTags(win, 5, 0, TAG(tagbuf, guiResizableGads, TRUE,
                   guiFlags, GUIInfoFlagSet{addBorderDims, doRefresh,
                                            vanillaKeysNotify, convertKeys},
                   guiGadFont, TopazAttr(), NIL));
    IF gui # NIL THEN
      innerWidth := win^.width - win^.borderRight - win^.borderLeft;
      innerHeight:= win^.height- win^.borderTop - win^.borderBottom;
      CreateSpecialGadget(gui, 20, 20, innerWidth-30, innerHeight-55,
                          progressIndicatorKind,
                          TAG(tagbuf, sgGadgetText, ADR('Progress'),
                        sgGadgetFlags, NewGadgetFlagSet{placetextAbove}, NIL));
      INCL(gui^.flags, addStdUnderscore);
      CreateGadgetFull(gui, 20, innerHeight-30, 70, 18, buttonKind,
                       ADR('_Plus'), NewGadgetFlagSet{placetextIn}, NIL);
      CreateGadgetText(gui, innerWidth-90, innerHeight-30, 70, 18, buttonKind,
                       ADR('_Minus'), NIL);
      EXCL(gui^.flags, addStdUnderscore);
      IF SetGUI(gui) = guiSet THEN
        prg := 0;
        LOOP
          WaitIntMsg(gui);

          IF    closeWindow IN gui^.msgClass THEN
            EXIT;
          ELSIF gadgetUp    IN gui^.msgClass THEN
            IF    gui^.gadID = 1 THEN
              IF prg < 10 THEN INC(prg) END;
              ModifyGadget(gui, 0,TAG(tagbuf, sgpiCurrentValue, prg * 10, NIL));
            ELSIF gui^.gadID = 2 THEN
              IF prg >  0 THEN DEC(prg) END;
              ModifyGadget(gui, 0,TAG(tagbuf, sgpiCurrentValue, prg * 10, NIL));
            END;
          ELSIF newSize     IN gui^.msgClass THEN
            innerWidth := win^.width - win^.borderRight - win^.borderLeft;
            innerHeight:= win^.height- win^.borderTop - win^.borderBottom;
            ResizeGadget(gui, 0, preserve, preserve,
                                 innerWidth-30, innerHeight-55);
            ResizeGadget(gui, 1, preserve, innerHeight-25,
                                 preserve, preserve);
            ResizeGadget(gui, 2, innerWidth-90, innerHeight-25,
                                 preserve, preserve);
            IF RedrawGadgets(gui, TRUE) # guiSet THEN EXIT END;
          END;
        END;
      END;
      RemoveGadgets(gui, TRUE);
      ClearWindow(gui);

      innerWidth := win^.width - win^.borderRight - win^.borderLeft;
      innerHeight:= win^.height- win^.borderTop - win^.borderBottom;
      CreateGadget(gui, 20, 10, innerWidth-35, innerHeight-45,
                   listviewKind, TAG(tagbuf, gtlvLabels, ADR(alist), NIL));
      INCL(gui^.flags, addStdUnderscore);
      CreateGadgetFull(gui, 20, innerHeight-30, 70, 18, buttonKind,
                       ADR('_Amigas'), NewGadgetFlagSet{placetextIn}, NIL);
      CreateGadgetText(gui, innerWidth-90, innerHeight-30, 70, 18, buttonKind,
                       ADR('_CPUs'), NIL);
      CreateSpecialGadget(gui, 10, 5, innerWidth-15, innerHeight-10,
                          bevelboxKind, TAG(tagbuf, sgbbRecessed, TRUE, NIL));
      IF SetGUI(gui) = guiSet THEN
        LOOP
          WaitIntMsg(gui);

          IF    closeWindow IN gui^.msgClass THEN
            EXIT;
          ELSIF gadgetUp    IN gui^.msgClass THEN
            IF    gui^.gadID = 1 THEN  (* Amiga-list *)
              ModifyGadget(gui, 0, TAG(tagbuf, gtlvLabels, ADR(alist), NIL));
            ELSIF gui^.gadID = 2 THEN  (* CPU-list *)
              ModifyGadget(gui, 0, TAG(tagbuf, gtlvLabels, ADR(clist), NIL));
            END;
          ELSIF newSize     IN gui^.msgClass THEN
            innerWidth := win^.width - win^.borderRight - win^.borderLeft;
            innerHeight:= win^.height- win^.borderTop - win^.borderBottom;
            ResizeGadget(gui, 0, preserve, preserve,
                                 innerWidth-35, innerHeight-45);
            ResizeGadget(gui, 1, preserve, innerHeight-30,
                                 preserve, preserve);
            ResizeGadget(gui, 2, innerWidth-90, innerHeight-30,
                                 preserve, preserve);
            ResizeGadget(gui, 3, preserve, preserve,
                                 innerWidth-15, innerHeight-10);
            IF RedrawGadgets(gui, TRUE) # guiSet THEN EXIT END;
          END;
        END;
      END;
    ELSE
      SimpleReqP(ADR('Unable to create gui-info-structure !'), okReqKind);
    END;
  ELSE
    SimpleReqP(ADR('Unable to open window !'), okReqKind);
  END;

CLOSE
  IF win # NIL THEN
    IF SetProcessWindow(oldWin) = NIL THEN END;
    CloseIntWindow(win);
    win := NIL;
  END;
  WHILE alist.tailPred # ADR(alist) DO    (* free lists *)
    FreeMem(RemTail(ADR(alist)), SIZE(Node));
  END;
  WHILE clist.tailPred # ADR(clist) DO    (* free lists *)
    FreeMem(RemTail(ADR(clist)), SIZE(Node));
  END;
END WBDemo.
