/************************************************************************
 *                                                                      *
 *                      MOUSE.CPP accompanies MOUSE.H                   *
 *                              Version 1.00                            *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *                          Created by Dan Watling                      *
 *                                                                      *
 ************************************************************************
/______________________________________________________________________*/


#include <dos.h>
#include <mouse.h>

#define MOUSE 0x33

int globax, globbx, globcx, globdx;

union REGS inregs, outregs;


/* Initalize the Mouse Driver */

void reset_mouse(void)
{
 inregs.x.ax = 0;

 int86(MOUSE,&inregs,&inregs);
}

/* Show the mouse */

void show_mouse(void)
{
 inregs.x.ax = 1;

 int86(MOUSE,&inregs,&inregs);
}

/* Hide the mouse */

void hide_mouse(void)
{
 inregs.x.ax = 2;

 int86(MOUSE,&inregs,&inregs);
}


/* Monitors the status of the mouse */

int monitor_mouse(void)
{
 inregs.x.ax = 3;

 int86(MOUSE,&inregs,&outregs);

 globax = outregs.x.ax;
 globbx = outregs.x.bx;
 globcx = outregs.x.cx;
 globdx = outregs.x.dx;

 return (globbx,globcx,globdx);
}

/* Retrieves the amount of times a button has been pressed */

int push_button(void)
{
 inregs.x.ax = 5;

 int86(0x33,&inregs,&outregs);

 globax = outregs.x.ax;
 globbx = outregs.x.bx;
 globcx = outregs.x.cx;
 globdx = outregs.x.dx;

 return(globbx,globcx,globdx);
}

/* Retrieves the amount of times a button was released */

void release_button(int button, int hor, int ver)
{
  inregs.x.ax = 6;
  inregs.x.bx = button;

  int86(MOUSE,&inregs,&outregs);

  globax = outregs.x.ax;
  globbx = outregs.x.bx;
  globcx = outregs.x.cx;
  globdx = outregs.x.dx;

  ver = globcx;
  hor = globdx;
}

/* Moves the mouse to the position specified */

void put_mouse(int mousex, int mousey)
{
 inregs.x.ax = 4;
 inregs.x.cx = mousey;
 inregs.x.dx = mousex;

 int86(MOUSE,&inregs,&outregs);

 globax = outregs.x.ax;
 globbx = outregs.x.bx;
 globcx = outregs.x.cx;
 globdx = outregs.x.dx;
}

/* Sets the Maximum Horizontal positions */

void max_hor(int min, int max)
{
 inregs.x.ax = 7;
 inregs.x.cx = min;
 inregs.x.dx = max;

 int86(MOUSE,&inregs,&inregs);
}

/* Sets the Maximum Vertical positions */

void max_ver(int min, int max)
{
 inregs.x.ax = 8;
 inregs.x.cx = min;
 inregs.x.dx = max;

 int86(MOUSE,&inregs,&inregs);
}

/* Sets both the Maximum Vertical and Horizontal positions */

void max_ver_hor(int left, int top, int right, int bottom)
{
 max_hor(left,right);
 max_ver(top,bottom);
}

/* Defines the cursor to use for graphics modes */

void setcursor(int XHotSpot, int YHotSpot, int shape_tables, int seg_shape_tables)
{
 struct SREGS segregs;

 inregs.x.ax = 9;
 inregs.x.bx = XHotSpot;
 inregs.x.cx = YHotSpot;
 inregs.x.dx = shape_tables;
 segregs.es = seg_shape_tables;

 int86x(MOUSE,&inregs,&inregs,&segregs);
}

/* Sets the movement ratio of the mouse */

void mouse_move_ratio(int ratio)
{
 inregs.x.ax = 15;
 inregs.x.cx = ratio;
 inregs.x.dx = ratio;

 int86(MOUSE,&inregs,&outregs);

 globax = outregs.x.ax;
 globbx = outregs.x.bx;
 globcx = outregs.x.cx;
 globdx = outregs.x.dx;
}

/* Defines a hidden area of the screen for the mouse; it won't show the
   cursor in that rectangle or square */

void hidden_area(int left, int top, int right, int bottom)
{
 inregs.x.ax = 16;
 inregs.x.cx = left;
 inregs.x.dx = top;
 inregs.x.si = right;
 inregs.x.di = bottom;

 int86(MOUSE,&inregs,&outregs);

 globax = outregs.x.ax;
 globbx = outregs.x.bx;
 globcx = outregs.x.cx;
 globdx = outregs.x.dx;
}
