/*
 * File......: SECTPCLU.C
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Borland C++
//       Version 3.1
//

#include <extend.h>
#include "internal.h"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SECPCLU()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Get the number of sectors per cluster on a drive.
 *  $SYNTAX$
 *      GT_SecPClu([<ncDrive>]) --> nSectorsPerCluster
 *  $ARGUMENTS$
 *      <ncDrive> is an optional parameter that is the id of the drive
 *      to be read. This paramater can be either a character value who's
 *      first character is taken as the drive letter or a numeric value
 *      where 0 = Default, 1 = A:, 2 = B:, etc... If no parameter is
 *      passed the default drive is used.
 *  $RETURNS$
 *      The size of a sector on the drive in bytes. If the drive is
 *      invalid the return value will be -1.
 *  $DESCRIPTION$
 *      GT_SecPClu() can be used to find the size in bytes of a sector
 *      on a disk.
 *  $EXAMPLES$
 *      // Each of the following print the size of a sector on drive C:
 *
 *      ? GT_SecPClu("C:")
 *      ? GT_SecPClu("C")
 *      ? GT_SecPClu("Clipper")         // First letter is used only.
 *      ? GT_SecPClu(3)
 *
 *      // The next two print the size of a sector on the current drive.
 *
 *      ? GT_SecPClu(0)
 *      ? GT_SecPClu()
 *  $SEEALSO$
 *      GT_CLUSTER() GT_CLUSFRE() GT_SECTSIZ()
 *  $END$
 */

CLIPPER GT_SecPClu()
{
        char Drive = _GT_Internal_GetDriveName(1);
        unsigned Result;

        asm     Mov     AH,0x36
        asm     Mov     DL,Drive
        asm     Int     0x21
        asm     Mov     Result,AX;
        if (Result == 0xFFFF)
        {
                _retnl(-1);
        }
        else
        {
                _retnl(Result);
        }
}
