/*
 * File......: ROLLFWD.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_ROLLFWD()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Roll a date forward
 *  $SYNTAX$
 *      GT_RollFwd( dDate )
 *  $ARGUMENTS$
 *      dDate - Date to roll forward
 *  $RETURNS$
 *      The rolled date
 *  $DESCRIPTION$
 *      Roll the given date forward to the next available week day
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GT_RollFwd( dDate )

/*****************************************************************************
 Purpose - Roll the given date forward to a week day
 Returns - Next available week day
 Author  - Martin Colloby
 Created - 11/9/90
******************************************************************************
 Parameters - dDate  - Date to consider
 Locals     - dDate1 - Nearest business date
 Privates   - None
 Externals  - None
*****************************************************************************/

* For now we are not concerned with bank holidays.

LOCAL dDate1

IF VALTYPE( dDate ) <> "D"
    GT_Warning( "Invalid date type passed to GT_RollFwd !" )
    RETURN NIL
ENDIF

DO CASE
    CASE DOW( dDate ) == 1
        * Sunday
        dDate1 := dDate + 1

    CASE DOW( dDate ) == 7
        * Saturday
        dDate1 := dDate + 2

    OTHERWISE
        * Weekday
        dDate1 := dDate

ENDCASE

* If the rolled-to date is in a different month to the start date, then we
* must roll back into the correct month.
IF MONTH( dDate1 ) != MONTH( dDate )
    dDate1 := dDate1 - 2
ENDIF

* Return the calculated date
RETURN( dDate1 )
*
