/*
 * File......: PRINFILE.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_PRINTFILE()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Output text to a file
 *  $SYNTAX$
 *      GT_PrintFile( nDown , cWhat , nLeftMgn , nHandle )
 *  $ARGUMENTS$
 *      nDown    - Number of rows to move down
 *      cWhat    - Text to be output
 *      nLeftMgn - Left margin of text
 *      nHandle  - Handle of text file
 *  $RETURNS$
 *      NIl
 *  $DESCRIPTION$
 *      Outputs the given text to a text file
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */
*
#include "GT_LIB.CH"

FUNCTION GT_PrintFile( nDown , cWhat , nLeftMgn , nHandle )

/*****************************************************************************
 Purpose - Output text to file
 Returns - None
 Author  - Martin Colloby
 Created - 04/24/92
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - nDown    - Number of rows to move down
              cWhat    - Text to be output
              nLeftMgn - Left margin of text
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL nCount := 0

DEFAULT nDown TO 1 , cWhat TO "" , nLeftMgn TO 0

* Move down the required number of rows
FOR nCount := 1 TO nDown
    FWRITE( nHandle , CHR( K_RETURN ) + CHR( K_CTRL_J ) )
NEXT nCount

* Output the text
FWRITE( nHandle , SPACE( nLeftMgn) + cWhat )

RETURN NIL
*
