/*
 * File......: MOVEPOS.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_MOVEPOS()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      General purpose TBrowse skip function
 *  $SYNTAX$
 *      GT_MovePos( cMode , cFirstKey , bCondition , nNumber , lEmpty )
 *  $ARGUMENTS$
 *      cMode      - Mode in which to move
 *      cFirstKey  - Key to search for
 *      bCondition - Conditional code block
 *      nNumber    - Number of records to skip
 *      lEmpty     - If .T., position pointer at LASTREC() + 1
 *  $RETURNS$
 *      The number of elements skipped
 *  $DESCRIPTION$
 *      A general purpose table based TBrowse skip routine.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_MovePos( cMode , cFirstKey , bCondition , nNumber , lEmpty )

/*****************************************************************************
 Purpose - Generic record positioning function for TBrowses
 Returns - None
 Author  - Martin Colloby
 Created - 20/07/92
******************************************************************************
 Parameters - cMode      - Mode in which to move
              cFirstKey  - Key to search for
              bCondition - Conditional code block
              nNumber    - Number of records to skip
              lEmpty     - If .T., position pointer at LASTREC() + 1
 Privates   - None
 Locals     - None
 Externals  - None
******************************************************************************
 Notes - Record positioning function, called by TBrowse goTop, goBottom,
         and skip blocks. Returns number of records actually skipped if in
         "Skip" mode.

         N.B. It's assumed the database is already positioned at the first
              matching key (for example, after a SEEK).
*****************************************************************************/

* Assume no movement was possible
LOCAL nActual    := 0
LOCAL lSoftStat  := .F.
LOCAL cCurYear   := ""
LOCAL cCurNumber := ""

DEFAULT lEmpty TO .F.

DO CASE
    CASE cMode == "First"
        SEEK cFirstKey

    CASE cMode == "Last"
        lSoftStat := SET( _SET_SOFTSEEK , .T. )
        SEEK ( LEFT( cFirstKey, LEN( cFirstkey ) - 1 ) ;
              + CHR( ( ASC( RIGHT( cFirstKey, 1 ) ) + 1 ) ) )
        SKIP -1
        SET( _SET_SOFTSEEK , lSoftStat )

    CASE cMode == "Skip"
        IF lEmpty
            GOTO LASTREC() + 1
            RETURN 0
        ENDIF

        DO CASE
            *  Moving backwards
            CASE nNumber < 0
                DO WHILE ( nActual > nNumber ) .AND. !BOF() ;
                                               .AND. EVAL( bCondition , cFirstKey )
                    SKIP -1
                    IF !BOF() .AND. EVAL( bCondition , cFirstKey )
                        nActual--
                    ENDIF
                ENDDO
                IF !EVAL( bCondition , cFirstKey )
                    SKIP +1
                ENDIF

            *  Moving forwards
            CASE nNumber > 0
                DO WHILE ( nActual < nNumber ) .AND. !EOF() ;
                                               .AND. EVAL( bCondition , cFirstKey )
                    SKIP +1
                    IF !EOF() .AND. EVAL( bCondition , cFirstKey )
                        nActual++
                    ENDIF
                ENDDO
                IF EOF() .OR. !EVAL( bCondition , cFirstKey )
                    SKIP -1
                ENDIF

            *  No movement requested, re-read current record
            OTHERWISE
                SKIP 0

        ENDCASE

ENDCASE

RETURN nActual
*
