;  File......: GT_WINDM.ASM
;  Author....: Lee Rothman
;  BBS.......: The Dark Knight Returns
;  Net/Node..: 050/069
;  User Name.: Lee Rothman
;  Date......: 15/04/93
;  Revision..: 1.0
;
;  This is an original work by Lee Rothman and is placed in the public
;  domain.
;
;  Modification history:
;  ---------------------
;
;  $Log$
;
;
;
;   $DOC$
;   $FUNCNAME$
;       GT_WINDMODE()
;   $CATEGORY$
;       Environment
;   $ONELINER$
;       Check if application is running in a windows dos box.
;   $SYNTAX$
;       GT_WindMode() --> nWindMode
;   $ARGUMENTS$
;       None
;   $RETURNS$
;       A Numeric value. (0, 2 or 3)
;   $DESCRIPTION$
;       GT_WindMode() can be used to see if your application is running
;       under MS Windows 3.1 and in what mode.
;   $EXAMPLES$
;       nWindMode := GT_WindMode
;       DO CASE nWindMode
;          CASE nWindMode == 0
;               ? "Not running in a Windows DOS box"
;          CASE nWindMode == 2
;               ? "Running in a Windows DOS box (Standard mode)
;          CASE nWindMode == 3
;               ? "Running in a Windows DOS box (Enhanced mode)
;       ENDCASE
;   $END$
;

include  extenda.inc
codeseg
CLpublic <GT_WindMode>
CLfunc   int GT_WindMode
Clcode
         mov ax, 160ah
         int 2fh
         cmp ax,0
         jz In_Win
         mov cx,0
     In_Win:
CLret    cx
end
