/*
    File......: GT_TextDate.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_TEXTDATE()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *      Return a text string of a date
 *  $SYNTAX$
 *      GT_TextDate([<dDate>]) => cLongDate
 *  $ARGUMENTS$
 *      <dDate> is the date to be used.
 *  $RETURNS$
 *      "WeekDay the NNth of Month, Year" as a string
 *  $DESCRIPTION$
 *      To return a text string giving the date in long
 *      hand for the date passed as the parameter.
 *  $EXAMPLES$
 *      cLongDate := GT_TextDate(DATE())
 *
 *      // "Thursday the 4th of February 1993"
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_TextDate(dDate)

LOCAL cLongDate := ''
LOCAL nDay := 0

Default dDate to DATE()

// First bit
nDay := DAY(dDate)
cLongDate := CDOW(dDate) + ' the ' + LTRIM(STR(nDay))

// St, nd, rd or th
DO CASE
    CASE nDay = 1 .OR. nDay = 21 .OR. nDay = 31
        // st
        cLongDate += 'st'

    CASE nDay = 2 .OR. nDay = 22
        // nd
        cLongDate += 'nd'

    CASE nDay = 3 .OR. nDay = 23
        // rd
        cLongDate += 'rd'

    OTHERWISE
        // th
        cLongDate += 'th'

ENDCASE

//  And the rest
cLongDate += ' of ' + CMONTH(dDate) + ' ' + ;
    STR(YEAR(dDate),4)

/*
    End of GT_TextDate()
*/
RETURN(cLongDate)

