/*
 File......: GT_SHUFL.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_SHUFL()
 *  $CATEGORY$
 *      Screen Saver
 *  $ONELINER$
 *      Shuffles screen in blocks of four characters
 *  $SYNTAX$
 *      GT_Shufl(<nSeconds>) -> NIL
 *  $ARGUMENTS$
 *      <nSeconds> This is the amount of seconds to pause between 'shuffles'
 *                 Defaults to 0 seconds
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Screen saver for any Clipper application. This screen saver shuffles
 *      blocks of 4 characters around the screen, it goes quite fast so a
 *      parameter is included to slow the thing down a bit.
 *  $EXAMPLES$
 *      GT_Shufl(0.2) -> NIL
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "gt_lib.ch"

* * * * * * * * *
FUNCTION GT_Shufl (nSeconds)
* * * * * * * * *
#define NORTH 1
#define SOUTH 2
#define EAST 3
#define WEST 4

local nDirection := NORTH, bInterrupt, nTimeout
local nRand := 0, f := 0
// possible directions...
local nNewDirs := { {SOUTH,EAST,WEST} ,;
                    {NORTH,WEST,EAST} ,;
                    {WEST ,SOUTH,NORTH},;
                    {NORTH,EAST,SOUTH} }

local nX := 0 , nY := 0
local nX1, nY1
local cCharAttrib
local cSwapChar
local cOldScreen
default nSeconds to 0

// m_csroff() // Turn off your mouse here

bInterrupt := GT_Interrupt()

cOldScreen := savescreen(0,0,maxrow(),maxcol())

do while TRUE // LOOP until interrupt is given.
   nTimeOut := seconds()

   // Now check the keyboard etc.
   if eval(bInterrupt)
      exit
   endif

   // Does the worm change direction ?
   nRand := val(right(str(seconds(),8,2),1))
   // Force this if the shuffle is going off the screen

   do while TRUE // till we get a valid direction ...

      do case
         case nDirection == NORTH .and. nX == 0
            nRand := 10 // impossible to get normaly !
         case nDirection == SOUTH .and. nX >= maxrow() -6
            nRand := 10 // impossible to get normaly !
         case nDirection == EAST .and.  nY == 0
            nRand := 10 // impossible to get normaly !
         case nDirection == WEST .and.  nY >= maxCOL() -6
            nRand := 10 // impossible to get normaly !
      endcase

      if nRand > 7
         nRand := val(right(str(seconds(),8,2),1))

         // we need to change direction.
         // Make Rand itself /3 so we get a 1,2,3 number
         nRand := round(nRand / 3,0)
         nRand := max(nRand,1)
         nRand := min(3,nRand)
         // Ok should be itself / 3 and either 1,2,3
         // probably not totaly random but who cares ?
         nDirection := nNewDirs[nDirection][nRand]
      else
         exit // found a valid direction
      endif

   enddo // till we get a valid direction

   // Now weve sorted out whether to change direction, we can shuffle the
   // screen elements a bit.

   // Move the point a bit
   nY1 := nY
   nX1 := nX

   do case
      case nDirection == NORTH
         nX1 := nX -3
      case nDirection == SOUTH
         nX1 := nX + 3
      case nDirection == EAST
         nY1 := nY -3
      case nDirection == WEST
         nY1 := nY + 3
   endcase

   cCharAttrib := savescreen(nX ,nY ,nX+2,nY+2)
   cSwapChar := savescreen(nX1,nY1, nX1+2,nY1+2)

   restscreen(nX,nY,nX+2,nY+2,cSwapChar)
   restscreen(nX1,nY1,nX1+2,nY1+2,cCharAttrib)
   nX := nX1
   nY := nY1

   // now pause for a moment to let the user see the effects
   do while Seconds() - nTimeOut < nSeconds ; enddo

enddo

restscreen(0,0,maxrow(),maxcol(),cOldScreen)
// m_csron() // Turn on your mouse cursor

RETURN NIL
