/*
    File......: GT_Message.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_MESSAGE()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      Display a message in a box on the screen
 *  $SYNTAX$
 *      GT_Message(<cText>,[<cTitle>],[<cColour>], ;
 *                 [<cBoxLines>],[<nTop>],[<nLeft>],[<nBottom>], ;
 *                 [<nRight>]) => lSuccess
 *  $ARGUMENTS$
 *      <cText> is the message to display.
 *
 *      <cTitle> is an optional title for the box.
 *
 *      <cColour> is an optional colour string.
 *
 *      <cBoxLines> are the optional box lines to use.
 *
 *      <nTop>,<nLeft>,<nBottom>,<nRight> are the
 *      corners of the box. As many or  as few of these may
 *      be used as required. The default is to centre the
 *      message.
 *  $RETURNS$
 *      .T. / .F. based on the success.
 *  $DESCRIPTION$
 *      Display a message in a box on the screen
 *  $EXAMPLES$
 *      // Message centered on the screen
 *      GT_Message('Hello?')
 *
 *      // Fix top left
 *      GT_Message('Hello?',NIL,NIL,NIL,05,10)
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

#define MINIMUM     36
#define BIAS        2.3

FUNCTION GT_Message(cText,cTitle,cSetColour,cBoxLines, ;
    nTop,nLeft,nBottom,nRight)

LOCAL cColour := SETCOLOR()
LOCAL cLine := ''
LOCAL nColumns := 0
LOCAL nCount := 0
LOCAL nCharCount := 0
LOCAL nFarRight := 0
LOCAL nFarBottom := 0
LOCAL nLineCount := 0

Default cText to ''
Default cTitle to ''
Default cSetColour to SETCOLOR()
Default cBoxLines to BOX_SS
Default nTop to -1
Default nLeft to -1
Default nBottom to -1
Default nRight to -1

//  How many ?
nCharCount := LEN(cText)

//  Sort out columns
nColumns := IF(nCharCount<MINIMUM, ;
    nCharCount, ;
    ROUND(SQRT(nCharCount)*BIAS,0)) + 03

//  Far right position
nFarRight := IF(nRight<0,INT((MAXCOL()+nColumns)/2),nRight)

DO CASE
    CASE nLeft >= 0 .AND. nRight >= 0
        // Both defined

    CASE nLeft >= 0
        // Set right
        nRight := nLeft + nColumns

    CASE nRight >=  0
        // Set left
        nLeft := nRight - nColumns

    OTHERWISE
        // Set both
        nRight := nFarRight
        nLeft := nRight - nColumns

ENDCASE

//  Legal Values ?
IF nLeft < 0
    nLeft := 0
ENDIF
IF nRight > nFarRight
    nRight := nFarRight
ENDIF

//  Reset columns and lines
nColumns := nRight - nLeft - 03
nLineCount := MLCOUNT(cText,nColumns)
nFarBottom := IF(nBottom<0,INT((MAXROW()+nLineCount)/2), ;
    nBottom)

DO CASE
    CASE nTop >= 0 .AND. nBottom >= 0
        // Set Neither

    CASE nTop >= 0
        // Set bottom
        nBottom := nTop + nLineCount + 01

    CASE nBottom >= 0
        // Set top
        nTop := nBottom - nLineCount - 01

    OTHERWISE
        // Set both
        nBottom := nFarBottom
        nTop := nBottom - nLineCount - 01

ENDCASE

//  Set limits
IF nTop < 0
    nTop := 0
ENDIF
IF nBottom > nFarBottom
    nBottom := nFarBottom
ENDIF

// Draw box
GT_Window(nTop,nLeft,nBottom,nRight,cBoxLines,cSetColour, ;
    cTitle)

//  Move left 2
nLeft += 02

//  Draw text
SETCOLOR(cSetColour)
FOR nCount := 1 TO nLineCount
    // Draw each line
    cLine := PADC(RTRIM(MEMOLINE(cText,nColumns,nCount)), ;
        nColumns)
    @ nTop+nCount, nLeft SAY cLine
NEXT
SETCOLOR(cColour)

/*
    End of GT_Message()
*/
RETURN(.T.)
