/*
 * File......: GTMDAYS.PRG
 * Author....: George Brennan
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: George Brennan
 * Date......: 23/03/93
 * Revision..: 1.0
 *
 * This is an original work by George Brennan and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

// NOTE: This code has been written for and compiled with Clipper 5.01a
//

/*  $DOC$
 *  $FUNCNAME$
 *		GT_MDAYS()
 *  $CATEGORY$
 *      Date
 *  $ONELINER$
 *		Days in the month
 *  $SYNTAX$
 *		GT_MDAYS( dValue ) -> nDaysInMonth
 *
 *  $ARGUMENTS$
 *		<dValue>   is a valid Clipper date
 *
 *  $RETURNS$
 *		A numeric value of the number of days in the month of the
 *		parameter date
 *
 *	$DESCRIPTION$
 *		GT_MDAYS() can be used to get the  number of days in the month for
 *				   a given date
 *
 *  $EXAMPLES$
 *
 *	  ? "Days in this month ", GT_MDAYS( DATE() )
 *
 *	  result : Days in this month	31
 *
 *	$END$
 */

#include "gt_lib.ch"         // used to pre-process DEFAULT

STATIC aDaysIn := {{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }, ;
				   { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }}

FUNCTION GT_MDAYS( dValue )

LOCAL nYear := 0
LOCAL nLeap := 0

	  DEFAULT dValue to date()

	  nYear := YEAR( dValue )
	  nLeap := if( ((nYear % 4)   == 0)  .AND. ;
				   (((nYear % 100) != 0) .OR.  ;
				   ((nYear % 400) == 0)), 2, 1)

RETURN ( aDaysIn[ nLeap ][ MONTH( dValue ) ] )
