/*
 File......: GT_INTER.prg
 Author....: Phillip Hamlyn
 BBS.......: The Dark Knight Returns
 Net/Node..: 050/069
 User Name.: Phillip Hamlyn
 Date......: 03/03/93
 Revision..: 1.0

 This is an original work by Phillip Hamlyn and is placed in the
 public domain.

 Modification history:
 ---------------------

 Rev 1.0 03/03/93
 Initial revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_INTERRUPT()
 *  $CATEGORY$
 *      Video
 *  $ONELINER$
 *      GET/SET block for screen saver interrupts
 *  $SYNTAX$
 *      GT_Interrupt([{|| bInterrupt} ]) -> NIL | bOldInterrupt
 *  $ARGUMENTS$
 *      <bInterrupt> This optional parameter replaces the current interrupt
 *                   trapping block. This block should return TRUE or FALSE
 *                   and will be evaluated by other modules in order to
 *                   determine how the user can interrupt their processing.
 *  $RETURNS$
 *      bOldInterrupt - The function returns the currently active interrupt
 *                      block.  When this block is Evaluated, it will return
 *                      TRUE or FALSE indicating whether the user has
 *                      interrupted the current process.
 *  $DESCRIPTION$
 *      Get-Set function that stores and returns a codeblock which is used to
 *      interrupt screen savers and other tasks. Screen savers should
 *      interrogate the functions return to see when they should stop rather
 *      than using inkey(), mouseclick() etc. The default interrupt block
 *      is {|| inkey() > 0 }.
 *  $EXAMPLES$
 *      GT_Interrupt( {|| Inkey() > 0 .or. MouseClick() > 0 } )
 *          --> bOldInterrupt
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#INCLUDE "gt_lib.ch"
#include "error.ch"

//===================
function GT_Interrupt ( bNewInter )
//===================
static bOldInter := {|| Inkey() != 0 }
local bRet, oError
bRet := bOldInter

if bNewInter != NIL
   // only assign the new interrupt if it is a code block
   if valtype(bNewInter) != TYPE_BLOCK
      // major error, the programmer should get to know about this.
      // only check here because other modules rely on this parameter
      // being a code block. Normaly I wouldnt bother and just let them
      // suffer when it eventualy falls over. Kind soul arn't I ?
      oError := ErrorNew()
      oError:description := "Non Codeblock parameter passed"
      oError:subcode := 1
      oError:subsystem := "GT_Interrupt"
      oError:severity := ES_ERROR
      // Fire up the error system
      eval(ErrorBlock(),oError)
   endif
   bOldInter := bNewInter
endif

return bRet
