/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: gt_inkey.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: 23/05/92
 * Revision..: 1.00
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_INKEY()
 *  $CATEGORY$
 *       Keyboard
 *  $ONELINER$
 *       Modified inkey() that calls setkey procedures
 *  $SYNTAX$
 *       GT_INKEY(<nWait>) --> nKey
 *  $ARGUMENTS$
 *       <nWait>  - how long to wait
 *  $RETURNS$
 *       nKey     - a modified INKEY() value
 *  $DESCRIPTION$
 *       Performs an inkey() and if there is an action block assigned
 *       to that key, it will evaluate the block and then negate the
 *       inkey() value.
 *
 *       Returning a negative value for those keys that have had a
 *       set key block assigned is a little different to the way
 *       waitkey() works in Funcky but I find this information to
 *       be more useful.
 *  $EXAMPLES$
 *
 *       set key K_F1 to helpme()
 *
 *       nVal := GT_inkey(0)
 *
 *       if nVal < 0
 *          ? "A set key procedure was called"
 *       endif
 *       "Inkey value " + nVal
 *
 *  $END$
 */

#include "gt_LIB.ch"

function GT_Inkey(nWait)

   local nKey
   local bExtra

   if nWait == NIL
      nKey := inkey()
   else
      nKey := inkey(nWait)
   endif

   if (bExtra := setkey(nKey)) != NIL
      eval(bExtra, procname(1), procline(1), "")
      nKey := -nKey
   endif

return nKey
