/*
    File......: GT_Help.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 09/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 09/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_HELP()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      A general purpose Help function.
 *  $SYNTAX$
 *      GT_Help(<cProcName>,<nProcLine>, <cVarName>) -> lSuccess
 *  $ARGUMENTS$
 *      <cProcName> is the name ofthe calling procedure.
 *
 *      <nProcLine> is the line numbr of the calling
 *      program.
 *
 *      <cVarName> is the name of the currently active get,
 *      if there is one.
 *  $RETURNS$
 *      lSuccess
 *  $DESCRIPTION$
 *      A general purpose Help function.
 *  $EXAMPLES$
 *      SetKey(K_F1,{ | cProc, nProcLine, cVarName | ;
 *          GT_Help(cProc,nProcLine,cVarName) } )
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_Help(cProcName,nProcLine,cVarName)

LOCAL cAlias := 'Help'
LOCAL cHelpMessage := ''
LOCAL cOptions := ' EscExit Ķ Scroll  '
LOCAL cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
LOCAL cTitle := ' HELP SCREEN '
LOCAL nBoxBottom := (MAXROW() - 05)
LOCAL nBoxLeft := 02
LOCAL nBoxRight := (MAXCOL() - 02)
LOCAL nBoxTop := 03
LOCAL nBoxWidth := (nBoxRight - nBoxLeft - 01)
LOCAL nColumn := COL()
LOCAL nCursor := SETCURSOR()
LOCAL nRow := ROW()
LOCAL nSelect := 0

Default cProcname to 'Default'
Default nProcLine to 0
Default cVarName to 'Default'

//  Called from here ?
IF UPPER(cProcName) = UPPER(PROCNAME())
    RETURN(NIL)
ENDIF

// Turn cursor off
GT_Nocursor()

//  Find help files
IF FILE(cAlias + '.DBF') .AND. FILE(cAlias + '.DBT')

    // Help files found
    nSelect := SELECT()

    // Ask to wait
    GT_Message('Please wait','Getting Help')

    // Open files
    IF .NOT. EMPTY(GT_Use(cAlias,{},cAlias))

        // Opened OK
        DBGOTOP()
        cVarName := SUBSTR(cVarName,1,LEN(FIELD->Variable_))
        cProcName := SUBSTR(cProcName,1,LEN(FIELD->Procedure_))
        DO CASE
            CASE .NOT. EMPTY(cVarName)
                // Find based on routine name
                LOCATE FOR FIELD->Variable_ = cVarName

            CASE .NOT. EMPTY(cProcName)
                // Find based on variable name
                LOCATE FOR FIELD->Procedure_ = cProcName

            OTHERWISE
                // Record 1 is default help

        ENDCASE

        // OK ?
        IF .NOT. FOUND() .OR. EOF()
            DBGOTOP()
        ENDIF

        // Got it OK
        cHelpMessage := FIELD->Memo_
        DBCLOSEAREA()
        SELECT(nSelect)

    ELSE

        // Unable to open help
        cHelpMessage := CRLF + PADC('Unable to open the help files',nBoxWidth)

    ENDIF

ELSE

    // No help files
    cHelpMessage := CRLF + PADC('There is currently no help available',nBoxWidth)

ENDIF

//  Draw box
SAVESCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
GT_Window(nBoxTop,nBoxLeft,nBoxBottom,nBoxRight,BOX_SS)
@ nBoxTop, nBoxLeft + 3 Say cTitle
@ nBoxBottom, nBoxLeft + 3 Say cOptions

//  Show
BEGIN SEQUENCE
    MEMOEDIT(cHelpMessage,nBoxTop+2,nBoxLeft+2,nBoxBottom-1,nBoxRight-1,.F.)
END SEQUENCE

//  Restore screen
RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
@ nRow, nColumn SAY ''
SETCURSOR(nCursor)

//  Flush the keyboard
KEYBOARD CHR(0)
INKEY()

/*
    End of GT_Help()
*/
RETURN(NIL)
