/*
    File......: GT_GoBottom.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 11/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 11/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_GOBOTTOM()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Move the filepointer to the last record
 *  $SYNTAX$
 *      GT_GoBottom([<bWhile>],[<bFor>],[<bFind>]) -> NIL
 *  $ARGUMENTS$
 *      <bWhile> Code block giving a while clause.
 *
 *      <bFor> Code block giving a for clause.
 *
 *      <bFind> Code block giving a value to compare against
 *      the index. Acts as a form of while clause.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Reposition the filepointer to the last record given
 *      a for/while clause.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_GoBottom(bWhile,bFor,bFind)

LOCAL cLast := ''
LOCAL cData := ''
LOCAL nLength := ''
LOCAL lFault := .T.

Default bWhile to { | | .NOT. EOF() }
Default bFor to { | | .T. }
Default bFind to NIL

IF bFind = NIL

    // Can't find directly
    DBGOTO(LASTREC()+1)

ELSE

    // Get value
    cData := EVAL(bFind)
    nLength := LEN(cData)

    // Increment value to bFind
    cLast := CHR(ASC(SUBSTR(cData,nLength,1))+1)
    cLast := SUBSTR(cData,nLength-1,1) + cLast

    //  Find first item not legal
    DBSEEK(cLast)

ENDIF

//  Should be last inwhile clause
DBSKIP(-1)

//  Skip back till while and for OK
DO WHILE EVAL(bWhile) .AND. .NOT. BOF()

    IF EVAL(bFor)

        lFault := .F.
        EXIT

    ENDIF

    DBSKIP(-1)

ENDDO

//  OK?
IF lFault
    DBGOTO(LASTREC()+1)
ENDIF
/*
    End of GT_GoBottom()
*/
RETURN(NIL)

