/*
    File......: GT_Directory.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/03/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/03/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *       GT_DIRECTORY()
 *  $CATEGORY$
 *       General
 *  $ONELINER$
 *       List files and directories
 *  $SYNTAX$
 *       GT_Directory([<cPath>],[cExtent],[<nTop>],[<nLeft>])
 *  $ARGUMENTS$
 *       <cPath> Path to list initially.
 *
 *       <cExtent> Extentions to list.
 *
 *       <nTop> Fix the window top.
 *
 *       <nLeft> Fix the window left column
 *  $RETURNS$
 *       cFileSelected
 *  $DESCRIPTION$
 *       List files and directories and allow selection of a
 *       file.
 *  $EXAMPLES$
 *  $END$
 */

#include "GtClippe.ch"
#include "directry.ch"

MEMVAR aNames

FUNCTION GT_Directory(cPath,cExtension,nTop,nLeft)

LOCAL aFiles := {}
LOCAL cAllExtent := '.*'
LOCAL cColour := SETCOLOR()
LOCAL cDirList := 'D'
LOCAL cDrive := 'C:'
LOCAL cDriveDelimeter := ':'
LOCAL cErrorMsg1 := 'No files or directories could be found.'
LOCAL cExtentDelimeter := '.'
LOCAL cFileSelected := ''
LOCAL cFind := ''
LOCAL cOptions := ;
    'EscExit              A/ZFind               Select              F1Help'
LOCAL cOtherOptions := ''
LOCAL cParentDir := '..'
LOCAL cPathDelimeter := '\'
LOCAL cScreen := SAVESCREEN(00,00,MAXROW(),MAXCOL())
LOCAL cWildCard1 := '*'
LOCAL nBottom := 00
LOCAL nCount := 0
LOCAL nMaxFiles := 0
LOCAL nRight := 00
LOCAL nSelected := 0

PRIVATE aNames := {}

Default cPath to ''
Default cExtension to '.*'
Default nTop to 04
Default nLeft to 02

//  Trim items
cPath := UPPER(LTRIM(RTRIM(cPath)))
cExtension := UPPER(LTRIM(RTRIM(cExtension)))

//  Ensure values are OK
IF EMPTY(cPath)
    // If no path, then specify current directory
    cPath := cPathDelimeter + CURDIR(cDrive)
ENDIF

IF RAT(cDriveDelimeter,cPath) > 0
    // Split drive from path
    nCount := RAT(cDriveDelimeter,cPath)
    cDrive := SUBSTR(cPath,1,nCount)
    cPath := SUBSTR(cPath,nCount+1)
ENDIF

IF cExtentDelimeter $ cPath
    // It has a file name in it
    cPath := IF(cPathDelimeter $ cPath, ;
        SUBSTR(cPath,1,RAT(cPathDelimeter,cPath)), ;
        cPathDelimeter+CURDIR(cDrive))
ENDIF

//  Add \ to end of path if not there
IF SUBSTR(cPath,LEN(cPath),1) != cPathDelimeter
    cPath += cPathDelimeter
ENDIF

DO CASE
    // Verify extention
    CASE EMPTY(cExtension)
        // Set ext
        cExtension := cAllExtent

    CASE cExtentDelimeter $ cExtension
        // ext OK

    OTHERWISE
        cExtension := cExtentDelimeter + ;
            SUBSTR(LTRIM(cExtension),1,3)

ENDCASE

BEGIN SEQUENCE
    DO WHILE .T.

        // Message
        GT_Message('Sorting Files ....','Please wait:')

        // Find files and update path
        cFind := cDrive + cPath + cWildCard1 + cAllExtent
        aFiles := DIRECTORY(cFind,cDirList)

        // Remove unwanted files
        nMaxFiles := LEN(aFiles)
        nCount := 1

        IF cExtension != cAllExtent

            DO WHILE .NOT. (nCount > nMaxFiles)

                IF (cExtension $ aFiles[nCount][F_NAME] ;
                    .OR. aFiles[nCount][F_ATTR] = 'D')

                    nCount ++

                ELSE

                    ADEL(aFiles,nCount)
                    nMaxFiles --

                ENDIF

            ENDDO
            ASIZE(aFiles,nMaxFiles)

        ENDIF

        cFind := cDrive + cPath + cWildCard1 + cExtension
        cOtherOptions := PADR(cFind,MAX(12,LEN(cFind)))

        // Find any ?
        nCount := LEN(aFiles)
        nBottom := MIN(nTop+nCount+3,MAXROW()-4)
        nRight := nLeft + LEN(cOtherOptions) + 02
        IF nCount < 1
            GT_AskUser(cErrorMsg1,{},'Error:')
            cFileSelected := ''
            EXIT
        ENDIF

        // Build list of files and dirs
        ASIZE(aNames,nCount)
        AEVAL(aFiles,{ | data,elem | aNames[elem] := data[1] })

        // Sort
        ASORT(aNames)

        // Select one
        RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)

        GT_Message(cOptions,'Options:',SETCOLOR(),BOX_SS, ;
            MAXROW()-02,00,MAXROW(),MAXCOL())

        nSelected := GT_Choose(aNames,cOtherOptions, ;
            nTop,nLeft,nBottom,nRight)
        RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)

        // What did they select ?
        IF nSelected <= 0
            // Esc ?
            cFileSelected := ''
            EXIT
        ENDIF

        cFind := STRTRAN(aNames[nSelected],' ','')
        DO CASE
            CASE cFind = cParentDir
                // Back one level
                nCount := RAT(cPathDelimeter,SUBSTR(cPath,1,LEN(cPath)-1))
                cPath := IF(nCount=0,cPathDelimeter,SUBSTR(cPath,1,nCount))

            CASE cFind = cExtentDelimeter
                // Ignore

            CASE FILE(cDrive+cPath+cFind)
                // File selected
                cFileSelected := cDrive + cPath + cFind
                EXIT

            OTHERWISE
                // Must be a directory
                cPath += cFind + cPathDelimeter

        ENDCASE

    ENDDO

ENDSEQUENCE

//  Restore the old screen
RESTSCREEN(00,00,MAXROW(),MAXCOL(),cScreen)
SETCOLOR(cColour)

//  Blank the keyboard
KEYBOARD CHR(0)
INKEY()

/*
    End of GT_Directory()
*/
RETURN(cFileSelected)

