/*
    File......: GT_AskQuit.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_ASKQUIT()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Ask the user if they would like to quit
 *  $SYNTAX$
 *      GT_AskQuit() -> lQuited
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      lQuited
 *  $DESCRIPTION$
 *      Ask the user if they would like to exit the program,
 *      and quit if they do.
 *  $EXAMPLES$
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_AskQuit()

LOCAL nLastKey := LASTKEY()

//  Ask
IF UPPER(CHR(GT_AskUser('Exit Program ? (Y/N)', ;
    {ASC('N'),ASC('Y'),ASC('n'),ASC('y')}))) = 'Y'

    // Said yes
    GT_Quit()

ENDIF

//  Reset Keyboard
KEYBOARD CHR(nLastKey)
INKEY()

/*
    End of GT_AskQuit()
*/
RETURN(.F.)

