/*
    File......: GT_a2Str.prg
    Author....: Martin Bryant
    BBS.......: The Dark Knight Returns
    Net/Node..: 050/069
    User Name.: Martin Bryant
    Date......: 04/02/93
    Revision..: 1.0

    This is an original work by Martin Bryant and is placed
    in the public domain.

    Modification history:
    ---------------------

    Rev 1.0 04/02/93
    PD Revision.
*/

/*  $DOC$
 *  $FUNCNAME$
 *      GT_A2STR()
 *  $CATEGORY$
 *      Array
 *  $ONELINER$
 *      Convert an array into a character string
 *  $SYNTAX$
 *      GT_a2Str(<aData>,<bConvert>,<nLength>) -> cData
 *  $ARGUMENTS$
 *      <aData> is the array of data. <bConvert> must be
 *      able to handle all data types found in the array.
 *
 *      <bConvert> is the Block function to convert the data
 *      from the array. This data will then be padded to
 *      <nLength> by the GT_a2Str().
 *
 *      <nLength> is the length to pad the items to in the
 *      string.
 *  $RETURNS$
 *      cData
 *  $DESCRIPTION$
 *      To turn an array into a character string, for saving to a
 *      mem file etc.
 *  $EXAMPLES$
 *      // Convert number  array to a string.
 *      aData := {0,2,7,51,9,4}
 *      cData := GT_a2Str(aData,{ | nVal | Str(nVal) },2)
 *      // Result is " 0 2 751 9 4"
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "GT_LIB.ch"

FUNCTION GT_a2Str(aData,bConvert,nLength)

Local cData := ''
Local nCount := 0
Local nItems := 0

Default aData to {}
Default bConvert to { | uData | uData }
Default nLength to 1

nItems := LEN(aData)

FOR nCount := 1 TO nItems

    cData += PADR(EVAL(bConvert,aData[nCount]),nLength)

NEXT

/*
    End of GT_a2Str()
*/
RETURN(cData)
