/*
 * File......: GTMATH08
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_INV()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Performs binary inversion on a character string
 *  $SYNTAX$
 *      GT_Inv(<cString>) --> <cString2>
 *  $ARGUMENTS$
 *      <cString> is any character string
 *  $RETURNS$
 *      <cString2> is a binary inverted version of <cString>
 *  $DESCRIPTION$
 *      This function takes a character string, turns it into a stream
 *      of binary digits (each eight 'bits' represents one character
 *      from the input string, and is it's ASCII value), then inverts
 *      the 'bits', and finaly turns the stream back into a string of
 *      ASCII characters.
 *
 *      Passing the inverted string back to the function will cause it
 *      to revert to it's initial state.
 *  $EXAMPLES$
 *      ? GT_Inv('101010')           // '010101'
 *
 *      ? GT_Inv('SAM')              // ''
 *
 *      ? GT_Inv(GT_Inv('SAM'))      // 'SAM'
 *  $SEEALSO$
 *      GT_BINARY() GT_BTOD() GT_DTOB()
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION GT_Inv(cString)
LOCAL xcounter, ycounter, zcounter
LOCAL tempString, bit, result := "", res := ""
zcounter := 8
cString := GT_Binary(cString)
FOR xcounter := 1 To len(cString)/8
   tempString := SubStr(cString,(xcounter*8)-7,8)
   res := ""
   FOR ycounter := 1 TO zcounter
      bit := IF( SubStr(tempString,ycounter,1) = '1', '0',;
                 '1' )
      res += bit
   NEXT
   result += Chr(GT_BToD(res))
NEXT
Return (result)
