/*
 * File......: GTMATH06
 * Author....: Philip Ide
 * BBS.......: Dark Knight Returns
 * Net/Node..:
 * User Name.: Philip Ide
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Philip Ide and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DTOB36()
 *  $CATEGORY$
 *      Maths
 *  $ONELINER$
 *      Turns a decimal integer into a Base36 number
 *  $SYNTAX$
 *      GT_DtoB36(<n> [,nLength]) --> <cB36Num>
 *  $ARGUMENTS$
 *      <n>       is a decimal integer
 *
 *      <nLength> is a ^bMINIMUM^b length string to return.
 *                If passed, this will cause the return value to be
 *                padded with leading zero's to the length specified.
 *                If the string is longer than <nLength>, it is not truncated.
 *
 *                If omitted, the return value is 'trimmed'.
 *  $RETURNS$
 *      <cB36Num> is a character string representing a Base36 number.
 *  $DESCRIPTION$
 *      This turns a decimal number into a Base36 number, represented by a
 *      string.  Large numbers can be stored in a very few bytes, so this is
 *      ideal for lookup table ID's, file offsets etc.
 *  $EXAMPLES$
 *      ? GT_DtoB36(12)        // 'C'
 *
 *      ? GT_DtoB36(1679615)   // 'ZZZZ'
 *
 *      ? GT_DtoB36(1679615,5) // '0ZZZZ'
 *
 *      ? GT_DtoB36(1679615,3) // 'ZZZZ'
 *  $SEEALSO$
 *      GT_B36TOD()
 *  $INCLUDE$
 *
 *  $END$
 */

#xcommand DEFAULT <a> TO <y> [,<b> TO <z>] ;
     => <a> := IF(<a> == NIL, <y>, <a>) ;
     [; <b> := IF(<b> == NIL, <z>, <b>)]

STATIC B36 := '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ'

FUNCTION GT_DtoB36(n,l) // n=Decnum, l=length of Base36 string to return
LOCAL retval := "", x, y

DEFAULT l TO 4
While (n>0)                                 // while we got a number...
   x := n%36                                // get modulus
   n := Int(n/36)                           // remove an exponent
   retval := SubStr(B36, x+1, 1)+retval     // add result to return string
End
l := Max(l,Len(retval))
Return (SubStr(Replicate('0',l)+retval,-l)) // ret padded with leading zero's
