/*
 * File......: GRPASSWO.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_GRPASSWORD()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Get reader for password entry
 *  $SYNTAX$
 *      GT_GRPassword( oGet , aGetExitKeys )
 *  $ARGUMENTS$
 *      oGet         - GET object
 *      aGetExitKeys - Array of keys that can cause exit from GET
 *  $RETURNS$
 *      .F.
 *  $DESCRIPTION$
 *      A GET reader for password entry.  Any keys pressed are placed in
 *      cargo and a block character is output to the screen.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_GRPassword( oGet , aGetExitKeys )

/*****************************************************************************
 Purpose - Get reader for password entry
 Returns - None
 Author  - Log
 Created - 07/01/93
******************************************************************************
 Parameters - oGet         - Get object
              aGetExitKeys - Keys that can cause exit from READ
 Privates   - None
 Locals     - nKey         - Key pressed by user
*****************************************************************************/

LOCAL nKey := 0

* Read the GET if the WHEN condition is satisfied
IF ( GetPreValidate( oGet ) )

    // activate the GET for reading
    oGet:SetFocus()

    DO WHILE ( oGet:exitState == GE_NOEXIT )

        // check for initial typeout (no editable positions)
        IF ( oGet:typeOut )
            oGet:exitState := GE_ENTER
        ENDIF

        // apply keystrokes until exit
        DO WHILE ( oGet:exitState == GE_NOEXIT )
            nKey := INKEY( 0 )

            DO CASE
                CASE nKey >= 32 .AND. nKey <= 255
                    oGet:cargo += UPPER( CHR( nKey ) )
                    GetApplyKey( oGet , ASC( "" ) , aGetExitKeys )

                CASE nKey == K_BS
                    oget:Cargo := LEFT( oget:Cargo , LEN( oget:Cargo ) - 1 )
                    GetApplyKey( oGet , K_BS , aGetExitKeys )

                OTHERWISE
                    GetApplyKey( oGet , nKey , aGetExitKeys )

            ENDCASE

        ENDDO

        // disallow exit if the VALID condition is not satisfied
        IF ( !GetPostValidate( oGet ) )
            oGet:exitState := GE_NOEXIT
        ENDIF

    ENDDO

    // de-activate the GET
    oGet:KillFocus()

    * If the user escaped from the GET, blank the password
    IF oGet:exitState == GE_ESCAPE
        oGet:Cargo := ""
    ENDIF

ENDIF

RETURN .F.
*
