/*
 * File......: GETHEAD.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.1
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 * 1.1 - 19/10/93 - Changed calls from CTOD to GT_STOD
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_GETHEADERSTRUCTURE()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Get the header structure of a DBF file
 *  $SYNTAX$
 *      GT_GetHeaderStructure( cDbf , lMemoExists , dUpdated , nRecords , ;
 *                             nOffset , nRecSize )
 *  $ARGUMENTS$
 *      cDbf        - DBF File to get header from
 *      lMemoExists - Is there a memo file (passed by reference)
 *      dUpdated    - Date file updated    (passed by reference)
 *      nRecords    - Number of records    (passed by reference)
 *      nOffset     - Data offset          (passed by reference)
 *      nRecSize    - Record size          (passed by reference)
 *  $RETURNS$
 *      File error code when accessing table. 0 if OK
 *  $DESCRIPTION$
 *      Opens the given table as a binary file and gets the header info.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "fileio.ch"

FUNCTION GT_GetHeaderStructure( cDbf , lMemoExists , dUpdated , nRecords , ;
                                nOffset , nRecSize )

/*****************************************************************************
 Purpose - Get the header of the given file
 Returns - File error code - 0 if OK
 Author  - Martin Colloby
 Created - 05/06/92
 Edited  - 21/07/92 by MKC - Modified to return FERROR() code
******************************************************************************
 Parameters - cDbf        - DBF File to get header from
              lMemoExists - Is there a memo file (passed by reference)
              dUpdated    - Date file updated    (passed by reference)
              nRecords    - Number of records    (passed by reference)
              nOffset     - Data offset          (passed by reference)
              nRecSize    - Record size          (passed by reference)
 Privates   - None
 Locals     - cBuffer     - Input buffer
              nHandle     - File handle of DBF
 Externals  - None
*****************************************************************************/

LOCAL cBuffer := SPACE( 12 )
LOCAL nHandle := 0

* See if the file exists
IF FILE( cDbf )
    * Open the file and get handle
    nHandle := FOPEN( cDbf , FO_READ )

    IF FERROR() == 0

        * Read the header into memory
        FREAD( nHandle , @cBuffer , 12 )

        IF ASC( LEFT( cBuffer , 1 ) ) == 131 .OR. ;
           ASC( LEFT( cBuffer , 1 ) ) == 3
            lMemoExists := ( ASC( LEFT( cBuffer , 1 ) ) == 131 )
            dUpdated    := GT_STOD( ALLTRIM( STR( ASC( SUBSTR( cBuffer , 2 , 1 ) ) ) ) + ;
                                    ALLTRIM( STR( ASC( SUBSTR( cBuffer , 3 , 1 ) ) ) ) + ;
                                    ALLTRIM( STR( ASC( SUBSTR( cBuffer , 4 , 1 ) ) ) ) )
            nRecords    := BIN2L( SUBSTR( cBuffer , 5  , 4 ) )
            nOffset     := BIN2W( SUBSTR( cBuffer , 9  , 2 ) )
            nRecSize    := BIN2W( SUBSTR( cBuffer , 11 , 2 ) )
        ENDIF
    ENDIF

    * Close the file and release the handle
    FCLOSE( nHandle )

ENDIF

RETURN( FERROR() )
*
