/*
 * File......: FTELL.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: 13/04/93
 * Revision..: 1.0
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "gt_lib.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      GT_FTELL()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Return the location of the file pointer in a low level file.
 *  $SYNTAX$
 *      GT_FTell(<nFileHandle>) --> nBytePosition
 *  $ARGUMENTS$
 *      <nFileHandle> is the handle of a file that has been opened or
 *      created with one of Clipper's low level file functions.
 *  $RETURNS$
 *      The byte position of the file pointer.
 *  $DESCRIPTION$
 *      GT_FTell() can be used for finding the location or a file
 *      pointer when working with files opened or created with Clipper's
 *      low level file functions.
 *  $EXAMPLES$
 *      // Print the location of the file pointer.
 *
 *      local nFile := fopen("LIFE.42")
 *      fseek(nFile,41)
 *      ? GT_FTell(nFile)     // Print the location in the file.
 *      fclose(nFile)
 *  $SEEALSO$
 *      GT_FSIZE() GT_FLOCATE()
 *  $END$
 */

function GT_FTell(nFileHandle)
return(fseek(nFileHandle,0,FS_RELATIVE))
