/*
 * File......: FILELOCK.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_FILLOCK()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Attempt to FLOCK() with optional retries
 *  $SYNTAX$
 *      GT_FilLock( nSeconds )
 *  $ARGUMENTS$
 *      nSeconds - Number of retries - 0 to retry indefinately
 *  $RETURNS$
 *      .T. if the file was locked
 *      .F. if the file was not locked
 *  $DESCRIPTION$
 *      Attempts to FLOCK the current area.  If it fails, waits for a second
 *      and tries again.  After nSeconds retries it fails.
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

*
FUNCTION GT_FilLock( nSeconds )

/*****************************************************************************
 Purpose - Attempt to FLOCK() with optional retries
 Returns - .T. if lock applied, .F. otherwise
 Author  - Martin Colloby
 Created - 20/05/92
******************************************************************************
 Parameters - nSeconds - Number of retries to make
 Privates   - None
 Locals     - lForever - If .T., loop forever
 Externals  - None
*****************************************************************************/

LOCAL lForever := (nSeconds == 0)

IF FLOCK()
    * Locked
    RETURN (.T.)
ENDIF

DO WHILE (lForever .OR. nSeconds > 0)
    * Wait 1/2 second
    INKEY(.5)
    nSeconds := nSeconds - .5
    IF FLOCK()
        * Locked
        RETURN (.T.)
    ENDIF
ENDDO

* Not locked
RETURN (.F.)
*
