/*
 * File......: FHEADER.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_PAGEFHEADER()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Outputs a page header to a text file
 *  $SYNTAX$
 *      GT_PageFHeader( cRepName, lPageReset, nLeftMgn, nRightMgn, ;
 *                      nPageWidth , nHeader , nHandle )
 *  $ARGUMENTS$
 *      cRepName    - Report name
 *      lPageReset  - If .T., reset the page number count
 *      nLeftMgn    - Left margin of page
 *      nRightMgn   - Right margin of page
 *      nPageWidth  - Width of page
 *      nHeader     - Row on which to start header
 *      nHandle     - Handle for binary file
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Output a page header consisting of the System Name , Report Name ,
 *      User Name , Date and Time to a file
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_LIB.CH"

FUNCTION GT_PageFHeader( cRepName, lPageReset, nLeftMgn, nRightMgn, ;
                         nPageWidth , nHeader , nHandle )

/*****************************************************************************
 Purpose - Output a page header consisting of the System Name , Report Name ,
           User Name , Date and Time
 Returns - None
 Author  - Martin Colloby
 Created - March 1992
 Edited  - 25/4/92 by Martin Colloby - Tidied up
******************************************************************************
 Parameters - cRepName    - Report name
              lPageReset  - If .T., reset the page number count
              nLeftMgn    - Left margin of page
              nRightMgn   - Right margin of page
              nPageWidth  - Width of page
              nHeader     - Row on which to start header
 Privates   - None
 Locals     - None
 PUBLICS    - cSystemName - Name of system
              cUserName   - Name of user
 Statics    - nPageNum    - Page number
              nConfMess   - "Private and Confidential" message
*****************************************************************************/

STATIC nPageNum := 0

DEFAULT lPageReset TO .F., nHandle TO -1

IF lPageReset
    nPageNum := 1
ELSE
    FWRITE( nHandle , CHR( 12 ) )
    nPageNum++
ENDIF

GT_PrintFile( nHeader , "" + REPLICATE( "", nPageWidth -;
                        nLeftMgn - nRightMgn - 2 ) + "" , nLeftMgn , nHandle )
GT_PrintFile( 1 , " " + cSystemName + ;
              SPACE( nPageWidth - nRightMgn - LEN( cRepName ) - 4 - LEN( cSystemName ) - nLeftMgn ) + ;
              cRepName + " " , nLeftMgn , nHandle )
GT_PrintFile( 1, "" + REPLICATE( "",nPageWidth - nLeftMgn - nRightMgn - 2 ) + "", nLeftMgn , nHandle )
GT_PrintFile( 1, " Printed By : " + cUserName + ;
              SPACE( nPageWidth - nRightMgn - 55 - 4 ) + ;
              "Date " + DTOC( DATE() ) + " " + ;
              "Time " + LEFT( TIME(), 5 ) + " " + ;
              "Page " + TRANSFORM( STR( nPageNum, 3 ), "999" ) + " " , nLeftMgn , nHandle )
GT_PrintFile( 1 , "" + REPLICATE( "",nPageWidth - nLeftMgn - nRightMgn - 2 ) + "" , nLeftMgn , nHandle )

RETURN NIL
*
