/*
 * File......: FERROR.PRG
 * Author....: Martin Colloby
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Martin Colloby
 * Date......: 18/4/93
 * Revision..: 1.0
 *
 * This is an original work by Martin Colloby and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *      GT_SHOWFERROR()
 *  $CATEGORY$
 *      File I/O
 *  $ONELINER$
 *      Show which file error occured
 *  $SYNTAX$
 *      GT_ShowFError()
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      Checks the value of FERROR() and outputs an error message in a box
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *      GT_LIB.CH
 *  $END$
 */

*
#include "GT_lib.ch"

FUNCTION GT_ShowFError()

/*****************************************************************************
 Purpose - Show the current FERROR code
 Returns - None
 Author  - Martin Colloby
 Created - 23/07/92
******************************************************************************
 Parameters - None
 Privates   - None
 Locals     - None
 Externals  - None
*****************************************************************************/

LOCAL cText := ""

DO CASE
    CASE FERROR() == 2
        cText := "File not found"

    CASE FERROR() == 3
        cText := "Path not found"

    CASE FERROR() == 4
        cText := "Too many files open"

    CASE FERROR() == 5
        cText := "Access denied"

    CASE FERROR() == 6
        cText := "Invalid handle"

    CASE FERROR() == 8
        cText := "Insufficient memory"

    CASE FERROR() == 15
        cText := "Invalid drive specified"

    CASE FERROR() == 19
        cText := "Attempt to write to write protected disk"

    CASE FERROR() == 21
        cText := "Drive not ready"

    CASE FERROR() == 23
        cText := "Data CRC error"

    CASE FERROR() == 29
        cText := "Write fault"

    CASE FERROR() == 30
        cText := "Read fault"

    CASE FERROR() == 32
        cText := "Sharing violation"

    CASE FERROR() == 33
        cText := "Lock violation"

ENDCASE

GT_Warning( { cText } )

RETURN NIL
*
