/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: envcount.c
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_ENVCOUNT()
 *  $CATEGORY$
 *      Environment
 *  $ONELINER$
 *      Returns the number of environment entries
 *  $SYNTAX$
 *      GT_EnvCount() --> nCount
 *  $ARGUMENTS$
 *      None
 *  $RETURNS$
 *      nCount  - The number of environment varibales
 *  $DESCRIPTION$
 *      Get the number of variables in the program's environment
 *      Reads the C startup variable to find the number of
 *      environment variables
 *  $EXAMPLES$
 *      ?  "There are " + str(GT_EnvCount(), 3) + " entries in the "
 *      ?? "environment table."
 *  $END$
 */

#include "extend.h"

extern char **environ;

CLIPPER
GT_envCount()
{
  int n = 0;

  while (environ[n++] != '\0')
    ;

  _retni(--n);
}
