/*
 * File......: DISKSIZE.PRG
 * Author....: Dave Pearson
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Dave Pearson
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Dave Pearson and is placed in the public
 * domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_DISKSIZE()
 *  $CATEGORY$
 *      Disk Drive
 *  $ONELINER$
 *      Return the size of a disk in bytes.
 *  $SYNTAX$
 *      GT_DiskSize([<ncDrive>]) --> nDiskSize
 *  $ARGUMENTS$
 *      <ncDrive> is an optional parameter that is the id of the drive
 *      to be checked. This paramater can be either a character value
 *      who's first character is taken as the drive letter or a numeric
 *      value where 0 = Default, 1 = A:, 2 = B:, etc... If no parameter
 *      is passed the default drive is used.
 *  $RETURNS$
 *      The size of the disk in bytes.
 *  $DESCRIPTION$
 *      GT_DiskSize() can be used the find the size of a disk in bytes.
 *  $EXAMPLES$
 *      // Each of the following print the size of drive C:
 *
 *      ? GT_DiskSize("C:")
 *      ? GT_DiskSize("C")
 *      ? GT_DiskSize("Clipper")         // First letter is used only.
 *      ? GT_DiskSize(3)
 *
 *      // The next two print the size of the current drive.
 *
 *      ? GT_DiskSize(0)
 *      ? GT_DiskSize()
 *  $END$
 */

function GT_DiskSize(ncDrive)
return(GT_SecPClu(ncDrive)*GT_SectSiz(ncDrive)*GT_Cluster(ncDrive))
