/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: acomp.prg
 * Author....: Andy M Leighton
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Andy Leighton
 * Date......: $Date$
 * Revision..: $Revision$
 *
 * This is an original work by Andy Leighton and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *       GT_ACOMP()
 *  $CATEGORY$
 *       Array
 *  $ONELINER$
 *       Same as Nantucket/CA supplied AComp() but without the bugs
 *  $SYNTAX$
 *       GT_aComp(<aArray>, <bComp>, <nStart>, <nStop>) --> nPos
 *  $ARGUMENTS$
 *       <aArray>   - the array to compare
 *       <bComp>    - the comparison block
 *       <nStart>   - the element at which to start
 *       <nStop>    - the element at which to stop
 *  $RETURNS$
 *       nPos       - the position of the element in the array which
 *                    satisfies <bComp>
 *  $DESCRIPTION$
 *       Same as Nantucket/CA supplied AComp() but without the bugs
 *  $EXAMPLES$
 *  $END$
 */

function GT_AComp(aArray, bComp, nStart, nStop)

   local value

/*
 * NOTE: in the Nantucket supplied code value was always
 *       initialised to aArray[1].  This is obviously wrong
 *       where nStart > 1
 */

   if nStart == NIL
      value := aArray[1]
   else
      value := aArray[nStart]
   endif

   aeval(                                                               ;
          aArray,                                                       ;
          {|x| value := if(eval(bComp, x, value), x, value)},           ;
          nStart,                                                       ;
          nStop                                                         ;
        )

return value
