***************************************************************************
*
* Procedure file: WINMOVE.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* WINMOVE - Window Move driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Moves screen window off screen of display while Screen Layout is executed.
* This prevents the visual delay of GET/SAY refresh becuase the window
* is moved by row/column 800,800 during the Screen Layout and back to the
* original position at the end of the READ Show routine.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE m.r,m.winname,m.codeline

* Ignore header record.
IF OBJCODE#63
  GOTO BOTTOM
  RETURN .F.
ENDIF

* Verify that the a window name has been defined in the Screen Layout.
IF EMPTY(NAME)
  =warning("Driver '"+PROGRAM()+"' requires ["+ALLTRIM(m.platform_)+;
           "] screen name to be defined")
  GOTO BOTTOM
  RETURN .F.
ENDIF

* Get current record pointer.
m.r=RECNO()

* Get window name through GENSCRNX's evltxt() routine to process any braces
* that may exist.
m.winname=evltxt(m.name)

* Create line of code to move window off screen.
m.codeline="MOVE WINDOW "+m.winname+" BY 800,800"

* Append code to Setup snippet if it doesn't already exist.  Note m.cr_lf
* is a private variable defined in GENSCRNX equal to CHR(13)+CHR(10).
IF .NOT.m.codeline$SETUPCODE
  REPLACE SETUPCODE WITH SETUPCODE+m.cr_lf+m.codeline
ENDIF

* Create line of code to move window back on screen.
m.codeline="IF WLROW('"+m.winname+"')>=800"+m.cr_lf+;
           "  MOVE WINDOW "+m.winname+" BY -800,-800"+m.cr_lf+"ENDIF"

* If the READ Show routine is defined as an expression and is empty, convert
* it to a procedure.
IF SHOWTYPE#1.AND.EMPTY(SHOW)
  REPLACE SHOWTYPE WITH 1
ENDIF

* If the READ Show routine is defined as a procedure, append code.
* Else if READ Show routine is defined as an expression, add code to
* end of the Screen Layout routine by adding an *:INSTXT object at the
* end of the .SCX database.  Use the insrec() function to insert the record
* and use the instxt() function to add the *:INSTXT + code the object.
* As noted above, all functions called are contained in GENSCRNX.
IF SHOWTYPE=1
  REPLACE SHOW WITH SHOW+m.cr_lf+m.codeline
ELSE
  GOTO BOTTOM
  IF insrec()
    =instxt1(m.codeline)
  ENDIF
ENDIF

* Go to bottom of .SCX database to have GENSCRNX skip calling this driver
* for every non-header record.
GOTO BOTTOM

RETURN .T.
