***************************************************************************
*
* Procedure file: NOSIZE.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* NOSIZE - No SIZE clause driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Removes SIZE clause from all objects
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE m.at_line,m.at_pos,m.i,m.memline

* Skip objects that do not generate a SIZE clause.
IF .NOT.drvobj().OR.(OBJTYPE#5.AND..NOT.BETWEEN(OBJTYPE,11,17))
  RETURN .F.
ENDIF

* If object's Comment snippet containes the *:SIZE directive, do not
* add the *:NOSIZE directive.  Note that the linesearch function is used
* to parse the given <expC>.  If the second parameter passed to the
* linesearch() function is a .T., the Setup snippet is parsed rather than
* the Comment snippet.
IF .NOT.linesearch(m.c_size)==m.null
  RETURN .F.
ENDIF

* Add the *:NOSIZE clause to objects Comment snippet by calling the size1()
* function in GENSCRNX with no parameters.  Note that a <expC> parameter was
* passed to the size1() function, the *:SIZE <expC> directive would be added
* the objects Comment snippet.  The size1() function is used to add both the
* *:SIZE <expC> directive and the *:NOSIZE directive.
RETURN size1()
