/*  Copyright (C) 1993, 1994, Russell Lang.  All rights reserved.

 This file is part of GSview.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GSVIEW General Public License for more details.

 Everyone is granted permission to copy, modify and redistribute
 this program, but only under the conditions described in the GSVIEW
 General Public License.  A copy of this license is supposed to have been
 given to you along with this program so you can know your rights and
 responsibilities.  It should be in a file named COPYING.  Among other
 things, the copyright notice and this notice must be preserved on all
 copies. */

/* gvceps.h */
/* Common data structures for EPS manipulation */

/* because Windows and PM define the same bitmap structures  */
/* with different names we use our own common structures */
/* BITMAP1 = Windows BITMAPCORE and PM BITMAPINFO */
/* BITMAP2 = Windows BITMAPINFO and PM BITMAPINFO2 */
/* RGB3 = Windows RGBTRIPLE and PM RGB */
/* RGB4 = Windows RGBQUAD and PM RGB2 */

#ifdef __EMX__
#pragma pack(1)		/* align structures to byte boundaries */
#endif

typedef struct tagRGB3
{
    BYTE    rgbtBlue;
    BYTE    rgbtGreen;
    BYTE    rgbtRed;
} RGB3;
typedef RGB3 GVFAR* LPRGB3;

typedef struct tagRGB4
{
    BYTE    rgbBlue;
    BYTE    rgbGreen;
    BYTE    rgbRed;
    BYTE    rgbReserved;
} RGB4;
typedef RGB4 GVFAR* LPRGB4;

typedef struct tagBITMAP1
{
    DWORD   bcSize;
    short   bcWidth;
    short   bcHeight;
    WORD    bcPlanes;
    WORD    bcBitCount;
} BITMAP1;
typedef BITMAP1 GVFAR* LPBITMAP1;

typedef struct tagBITMAP2
{
    DWORD   biSize;
    LONG    biWidth;
    LONG    biHeight;
    WORD    biPlanes;
    WORD    biBitCount;
    DWORD   biCompression;
    DWORD   biSizeImage;
    LONG    biXPelsPerMeter;
    LONG    biYPelsPerMeter;
    DWORD   biClrUsed;
    DWORD   biClrImportant;
} BITMAP2;
typedef BITMAP2 GVFAR* LPBITMAP2;

typedef struct tagBITMAPFILE
{
    WORD    bfType;
    DWORD   bfSize;
    WORD    bfReserved1;
    WORD    bfReserved2;
    DWORD   bfOffBits;
} BITMAPFILE;
typedef BITMAPFILE GVFAR* LPBITMAPFILE;


struct eps_header_s {
    char id[4];
    DWORD ps_begin;
    DWORD ps_length;
    DWORD mf_begin;
    DWORD mf_length;
    DWORD tiff_begin;
    DWORD tiff_length;
    WORD  checksum;
};

#ifdef __EMX__
#pragma pack()
#endif

/* in gvpeps.c or gvweps.c */
LPBITMAP2 get_bitmap(void);
void release_bitmap(void);

/* in gvceps.c */
unsigned long dib_bytewidth(LPBITMAP2 pbm);
unsigned int dib_pal_colors(LPBITMAP2 pbm);
void make_eps_tiff(int type);
void make_eps_interchange(void);
void extract_doseps(int command);

