#! /bin/sh 
#
# This shell script receives a postscript file on stdin
# and prints it on the paintjet printer. It uses a named pipe
# to feed ghostscript with stdin as if it was a file.
# It uses the pipe option to send the output directly to
# lpr.
#

if [ $# -gt 0 ] ; then 
  gs-x -dNODISPLAY -p"lpr -s -Ppaintjetg" paintjet-init.ps $1 quit.ps
else
   mknod /tmp/gs.$$ p
   cat | ( cat >>/tmp/gs.$$ & )
   gs-x -dNODISPLAY -p"lpr -s -Ppaintjetg" paintjet-init.ps /tmp/gs.$$ quit.ps
   rm /tmp/gs.$$
fi

