/* Copyright (C) 1989, 1990 Aladdin Enterprises.  All rights reserved.
   Distributed by Free Software Foundation, Inc.

This file is part of Ghostscript.

Ghostscript is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
to anyone for the consequences of using it or for whether it serves any
particular purpose or works at all, unless he says so in writing.  Refer
to the Ghostscript General Public License for full details.

Everyone is granted permission to copy, modify and redistribute
Ghostscript, but only under the conditions described in the Ghostscript
General Public License.  A copy of this license is supposed to have been
given to you along with Ghostscript so you can know your rights and
responsibilities.  It should be in a file named COPYING.  Among other
things, the copyright notice and this notice must be preserved on all
copies.  */

/* gdevpjet.h */
/* Specific part of modified GhostScript for printer driver */
/* for the HP PaintJet COLOR printer. */
#ifdef __MSDOS__
#include <io.h>				/* for setmode */
#include <fcntl.h>			/* for O_BINARY */
#endif
#include "malloc_.h"
#include "string_.h"
#include "gs.h"
#include "gxbitmap.h"
#include "gsmatrix.h"			/* for gxdevice.h */
#include "gxdevice.h"

#define FREE        0
#define DISK        1
#define MEMORY      2
#define UNKNOWN     0
#define NO_COLOR    0
#define HAS_COLOR   (!NO_COLOR)                   /* (local) */
#define ONE_BIT     1
#define WHITE	    1				  /* (local) */
#define BLACK	    0				  /* (local) */
#ifndef FALSE
#   define FALSE	0
#endif
#ifndef TRUE
#   define TRUE		!(FALSE)
#endif

typedef struct gx_device_s gx_device ;

/* Flag to control the opening of the file or the opening of the pipe to lpr. */ 
int open_printer_stream_as_pipe ; /* local */
/* Name of the file to print in. */
char *prn_output_stream_name ; /* local */


/* struct for defining local procs */ /* (local) */
struct local_procs_s
{
  int (*print_blk) (P2(gx_device *, FILE *)) ;
  int (*write_bit_blk) (P5(gx_device *, int, int, int, int)) ;
  int (*write_byte_blk) (P5(gx_device *, int, int, int, int)) ;
} ;

typedef struct local_procs_s prn_local_procs ;/* (local) */
		    

/* Printer dependent procedures */               /* (local) */
int print_blk_PaintJet(P2(gx_device *, FILE *)) ;

int write_bit_blk_PaintJet(P5(gx_device *, int, int, int, int)) ;

int write_byte_blk_PaintJet(P5(gx_device *, int, int, int, int)) ;

/* Description of block use for virtual memory  */
typedef struct vm_blk_s vm_blk;
struct vm_blk_s {
	char status;            /* block can be FREE, on DISK or in MEMORY */
	char *mem_ptr;          /* use to locate beginning of block in memory */
};

/* We need a specific "printer" device because our printer driver is */
/* differently implemented. */
typedef struct paintjet_device_s
{
  gx_device_common;
  prn_local_procs *local_procs ; /* printer dependent functions *//* (local) */
  FILE *output_file ;		 /* output stream for writing */
  vm_blk *blk;                   /* virtual memory block description */
  unsigned byte_in_row;  	 /* bytes in a row of block */
  long vm_mem;            /* memory used by virtual memory block for MS-DOS */
  long size_of_blk;       /* size in byte of a block */
  char max_blk;           /* number of block use in virtual memory */
  char row_last_blk;      /* number of row for the last block */
} paintjet_device ;

int paintjet_open(P1(gx_device *));

int paintjet_close(P1(gx_device *));

gx_color_index paintjet_map_rgb_color (P4(gx_device *, unsigned short, unsigned short, unsigned short));

int paintjet_map_color_rgb (P3(gx_device *, gx_color_index, unsigned short *));

int paintjet_output_page(P1(gx_device *));

int paintjet_copy_mono(P10(gx_device *, unsigned char *, int, int, int, int,
		      int, int, gx_color_index, gx_color_index));

int paintjet_copy_color(P8(gx_device *, unsigned char *, int, int, int, int,
		      int, int /*, int*//*local*/)); 

int paintjet_fill_rectangle(P6(gx_device *, int, int, int, int, gx_color_index));

int paintjet_tile_rectangle(P8(gx_device *, gx_bitmap *, int, int, int, int,
			  gx_color_index, gx_color_index)); 


static gx_device_procs paintjet_procs =
{
  paintjet_open,
  gx_default_get_initial_matrix,
  gx_default_sync_output,
  paintjet_output_page,
  paintjet_close,
  paintjet_map_rgb_color,
  paintjet_map_color_rgb,
  paintjet_fill_rectangle,
  paintjet_tile_rectangle,
  paintjet_copy_mono,
  paintjet_copy_color,
  gx_default_draw_line,
  gx_default_fill_trapezoid,
  gx_default_tile_trapezoid
};

static prn_local_procs local_procs_PaintJet =
{
  print_blk_PaintJet,
  write_bit_blk_PaintJet,
  write_byte_blk_PaintJet
} ;/* (local) */

#define GS_PRN_DEVICE gs_paintjet_device
#define DEVICE_NAME "paintjet"
#define X_DENSITY 180 			/* pixels per inch */
#define Y_DENSITY 180 			/* pixels per inch */
#define LINE_WIDTH ((int)(8.5 * X_DENSITY))
#define PAGE_HEIGHT (11 * Y_DENSITY)
#define PRN_OPEN paintjet_open
#define PRN_CLOSE paintjet_close
#define PRN_OUTPUT_PAGE paintjet_output_page

paintjet_device gs_paintjet_device =
{
  sizeof(paintjet_device),	/* generic portion of the paintjet device */
  &paintjet_procs,
  DEVICE_NAME,
  LINE_WIDTH,	/* width */
  PAGE_HEIGHT,	/* height */
  X_DENSITY,
  Y_DENSITY,
  HAS_COLOR,	/* the paintjet is a color device */
  1,		/* rgb_max_value */
  3,		/* bits per color pixel */
  0,		/* not initialized yet */
				/* end of generic portion */
  &local_procs_PaintJet,   /* local functions */
  (FILE *)NULL,		    /* output file will be determine in open proc */
  UNKNOWN,         /* virtual memory block ptr, initialize in open_device */
  576,
           /* total number of bytes for one complete row e.g. the number of */
	   /* bytes for describing one row of one bit plane * number of bit */
	   /* planes. Note that each row-bit-palne has to do full bytes. */
  131072L, /* 128Kb of ram memory should be used by virtual memory block */
  36864L,
	   /* size in byte of a block of 64 rows */
	   /* Remember that for one row of pixels on the printer, there is */
	   /* bits_per_color_pixel rows in memory. */
  31,      /* number of block used for a 11 inches pages (1980 lines)*/
  60,       /* number of row for the last block 1980 % 64 */
};  /* (local) */

extern char *prn_output_stream_name;
