PROGRAM displayGIFheader; {$i-}
{------------------------------------------------------------------------------

                            REVISION HISTORY

v1.00  : 1993/08/19.  First public release.  DDA
v1.01  : 1994/08/09.  Rewrote most of program - MUCH more efficient now!  DDA

------------------------------------------------------------------------------}

USES dos;
TYPE
  gif_header=RECORD
    gif_version : ARRAY[1..6] OF char;
    width,
    height      : word;
    resolution  : byte;  {  The next byte is "background", but I  }
  END;                   {  don't want to report it at this time. }

PROCEDURE showhelp;
CONST
  progdesc = 'GRR- Free DOS utility: GIF file information displayer.';
  author   =
    'v1.01: August 9, 1994. (c) 1994 by David Daniel Anderson - Reign Ware.';
  usage =
    'Usage:  GRR [directory and/or file_spec[.GIF]]   Example:  GRR mariah*';
BEGIN
  writeln (progdesc);
  writeln (author);
  writeln (usage);
  halt (1);
END;

FUNCTION leadingzero (w :word) : STRING;
VAR
  s : STRING;
BEGIN
  str (w :0, s);
  IF (length (s) = 1) THEN
    s:='0'+s;
  leadingzero:=s;
END;

FUNCTION stretch (astring :STRING; newlen :byte) : STRING;
BEGIN
  WHILE (length (astring) < newlen) DO
    astring:=astring+' ';
  stretch:=astring;
END;

PROCEDURE getpath (VAR new_path :pathstr);
BEGIN
  IF (paramstr (1) = '') THEN
    new_path:='*.gif'
  ELSE BEGIN
    new_path:=paramstr (1);
    IF (pos ('.', new_path) = 0) THEN
      new_path:=new_path+'*.gif'
    ELSE
      new_path:=copy (new_path, 1, pos ('.', new_path))+'gif';
  END;
END;

PROCEDURE writetime (fdatetime :longint);
VAR
  Year2       : STRING;
  DateTimeInf : DateTime;
BEGIN
  UnpackTime (fdatetime, DateTimeInf);
  WITH DateTimeInf DO BEGIN
    Year2:=LeadingZero (Year);
    Delete (Year2, 1, 2);
    Write
      (LeadingZero (Month):4,'-', LeadingZero (Day) ,'-', Year2, '  ',
        LeadingZero (Hour)   ,':', LeadingZero (Min) ,':', LeadingZero (Sec));
  END;
END;

PROCEDURE checkforgiflite (VAR thefile :FILE);
VAR
   giflite    : ARRAY[1..7] OF char;
   br_err     : integer;
BEGIN
  seek (thefile, 784);
  blockread (thefile, giflite, sizeof (giflite), br_err);
  IF (giflite = 'GIFLITE') THEN writeln ('GL')
  ELSE writeln ('--');
END;

VAR
  header  : gif_header;

  gpath   : pathstr;
  gdir    : dirstr;
  gname   : namestr;
  gext    : extstr;
  dirinfo : searchrec;

  gifname : STRING [12];
  giffile : FILE;
  read_result : integer;

BEGIN
  getpath (gpath);
  fsplit (fexpand (gpath), gdir, gname, gext);
  findfirst (gpath, hidden+archive, dirinfo);
  IF (doserror <> 0) THEN showhelp;
  WHILE (doserror = 0) DO BEGIN
    gifname:=dirinfo.name;
    assign (giffile, gdir+gifname);
    reset (giffile, 1);
    IF (IOResult = 0) THEN BEGIN
      blockread (giffile, header, sizeof (header), read_result);
      IF (read_result <> 1) THEN
        WITH header DO BEGIN
          IF (pos ('GIF' , gif_version) <> 1) THEN gif_version:='GIF???';
          write ((stretch (gifname, 12)), dirinfo.size :9);
          writetime (dirinfo.time);
          write (gif_version :10, '   [', width :4, height :5, 
                  (2 SHL (resolution AND 7)) :5, ' ] ');
                  {clever (SWAG) formula!}
          IF (resolution > 128) THEN write ('GCM/')
          ELSE write ('---/');
          checkforgiflite (giffile);
        END;
      close (giffile);
    END;
    findnext (dirinfo);
  END;
END.
