*  The purpose of this procedure is to strip out the file name from
*  a drive/path specification

parameter cName

if type('cName') <> 'C'
	return .f.
endif

cName = upper(alltrim(cName))
if substr(cName, 2, 1) == ':'
	cName = substr(cName, 3)
endif
if '\' $ cName
	cName = substr(cName, rat('\', cName) + 1)
endif
if '.' $ cName
	cName = left(cName, at('.', cName) - 1)
endif
return cName
