*  The purpose of this program is to create a FoxPro compatible
*  help file for the GPLIB.DOC.
*
*  To create a FoxPro Help file, from the command window type
*	DO MAKEHELP
*
*  This will create the FoxPro help database.  At any time in the future,
*  when you need this help file, you can access it by issuing the command
*  SET HELP TO GPHELP.
*
*  To set the help file back to the standard FoxPro Help file issue
*  the command SET HELP TO.
#define CR_LF chr(13)+chr(10)
close all
clear
if set('TALK') = 'ON'
	set talk off
	LastTalk = 'ON'
else
	LastTalk = 'OFF'
endif
define window Intro from 3, 5 to 19, 75 system color scheme 5 title " GPLIB MakeHelp System " shadow footer " ESC to abort "
activate window Intro
text

  MakeHelp has the capability to translate "See Also" to a text
  string that you specify.  If you are using a non-English
  language version of FoxPro you can enter the text that
  corresponds to See Also for your version of FoxPro.  Making
  this translation will enable the See Also function of the
  FoxPro Help system to operate with the GPLIB Help file.
endtext
Foreign = .f.
TransString = space(20)
@10, 2 say 'Are you using a non-English version of FoxPro? ' get Foreign picture "Y"
@12, 2 say 'Enter your language equivalent of See Also ' get TransString when Foreign
read
deactivate window Intro
release window Intro
if lastkey() = 27
	return
endif
TransString = alltrim(transString)
set help to (sys(2004)+'FOXHELP')
create table GPHELP ( topic C(30), Details M(8), class C(20))
File_Handle = fopen("GPLIB.DOC")
if File_Handle < 0
	wait window "Error Opening GPLIB.DOC"
	return
endif
TotalSize = fseek(file_handle, 0, 2)
MTopic = ""
MemField = ""
= fseek(file_handle, 0, 0)
do while .not. feof(file_handle)
	CurrentLine = fgets(File_Handle, 2048)
	if empty(MTopic) .and. .not. isalpha(CurrentLine)
		loop
	endif
	if empty(MTopic) .and. isalpha(CurrentLine)
		MTopic = left(CurrentLine, at(")", CurrentLine))
		MCLass = "Function"
		if empty(MTopic)
			MTopic = CurrentLine
			MClass = "General"
		endif
	endif
	if CurrentLine = chr(12)
		CurrentPos = fseek(file_handle, 0, 1)
		wait window 'MakeHelp conversion ' + ltrim(str((CurrentPos / TotalSize) * 100)) + '% done.' nowait
		append blank
		if MClass = "General"
			replace topic with " " + mtopic
		else
			replace topic with MTopic
		endif
		TopicLine = ;
				"ķ" + CR_LF + ;
				""    + padc(MTopic, 33) +       "" + CR_LF + ;
				"Ľ" + CR_LF + CR_LF
		replace class with MClass
		if Foreign
			replace details with TopicLine + strtran(MemField, 'See Also', TransString)
		else
			replace details with TopicLine + MemField
		endif
		MTopic = ""
		MemField = ""
	else
		MemField = MemField + CurrentLine + CR_LF
	endif
enddo
= fclose(File_Handle)
wait window "MakeHelp conversion complete." timeout 2
use
set help to GPHELP
set talk &LastTalk
help
