UNIT HpCopy;
{ To allow dump of graphics images to HP LaserJet printer }
{ Supplied by BORLAND TECH SUPPORT }

Interface

USES Crt, Dos, Graph;

VAR
  LST : Text;

Procedure HPHardCopy;

Implementation

Var
  Aspekt, Width, Height : Word;
  Vport : ViewPortType;

  {$F+}

  Function LSTNoFunction( Var F : TextRec) : Integer;
  begin
    LSTNoFunction := 0;
  end;

  Function LSTOutPutToPrinter( var F : TextRec) : Integer;
  Var
    Regs : Registers;
    P : Word;

Begin
  With F DO
  begin
    P:=0;
    Regs.AH:=16;
    While ( P < BufPos ) and ((Regs.AH and 16)=16) DO
    begin
      Regs.AL:=Ord(BufPtr^[P]);
      Regs.AH:=0;
      Regs.DX:=UserData[1];
      Intr($17,Regs);
      Inc(P);
    end;
    BufPos :=0;
  end;
  If((Regs.AH and 16)=16) then
    LstOutPutToPrinter :=0          { No Error }
  Else
    If ((Regs.AH and 32) =32) then
      LSTOutPutToPrinter := 159      { out of paper }
    else
      LSTOutPutToPrinter := 160;      { Device Write Fault }
end;

{$F-}

Procedure AssignLST(Port : Byte);
begin
  With TextRec(Lst) do
  begin
    Handle:=$FFF0;
    Mode := fmOutput;
    BufSize:= SizeOf(Buffer);
    BufPtr:= @Buffer;
    BufPos := 0;
    OpenFunc := @LSTNoFunction;
    InOutFunc:= @LSTOutPutToPrinter;
    FlushFunc:= @LSTOutPutToPrinter;
    CloseFunc:= @LSTOutPutToPrinter;
    UserData[1]:=Port-1;
  end;
end;

Function GetAspectX : Word;
begin
  GetAspectX:=Word(Ptr(Seg(GraphFreeMemPtr),Ofs(GraphFreeMemPtr)+277)^);
end;

Procedure SetAspectRatio( NewAspect : word);
begin
  Word(Ptr(Seg(GraphFreeMemPtr),Ofs(GraphFreeMemPtr)+277)^) := NewAspect;
end;

Procedure HPHardCopy;
Const DotsPerInch ='100';
CursorPosition = '5';
Esc = #27;
Var
  LineHeader : string[6];
  LineLength : string[2];
  Y : Integer;
  Procedure DrawLine(Y:integer);
  var
   GraphStr : string[255];
   Base : word;
   BitNo, ByteNo,DataByte : Byte;

   begin
     FillChar(GraphStr,SizeOf(GraphStr),#0);
     GraphStr :=LineHeader;
     for ByteNo := 0 to width do
     begin
       DataByte := 0;
       Base := 8*ByteNo;
       For BitNo := 0 to 7 do
       begin
         If GetPixel(BitNo+Base,Y) > 0
           then
             DataByte := DataByte + 128 Shr BitNo;
       end;
       GraphStr:=GraphStr+Chr(DataByte);
     end;
     write(Lst,GraphStr);
   end; { of DrawLine }

begin { main HPCopy }
  Aspekt := GetAspectX;
  SetAspectRatio(4950);
  FillChar(LineLength,SizeOf(LineLength),#0);
  FillChar(LineHeader,SizeOf(LineHeader),#0);
  GetViewSettings(Vport);
  width:=(Vport.X2+1) - Vport.X1;
  width:=((width-7) div 8);
  Height:= Vport.Y2 - Vport.Y1;
  write(lst,Esc+'E');
  write(lst,Esc+'*t'+DotsPerInch+'R');
  write(lst,Esc+'&a'+CursorPosition+'C');
  write(lst,Esc+'*r1A');
  Str(Width+1,LineLength);
  LineHeader:=Esc+'*b'+LineLength+'W';
  For Y := 0 to Height + 1 DO
  begin
    DrawLine(Y);
    DrawLine(Y);
  end;
  write(lst,Esc+'*rB');
  write(lst,Esc+'E');
end;
begin
  assignLST(1);
end.
  SetAspectRatio(Aspekt);
end.