/* The dirty system-dependent thingies.
   Copyright (C) 1995, 1996, 1997 Free Software Foundation, Inc.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* This file is included by wget.h.  The .c files need not include it. */

#ifndef SYSTHINGS_H
#define SYSTHINGS_H

/* The S_* macros are broken on some systems. */
#ifdef NeXT
#ifndef S_ISDIR
# define S_ISDIR(m) (((m) & (_S_IFMT)) == (_S_IFDIR))
#endif
#endif
 
#ifdef ultrix
#ifndef S_ISLNK
# define S_ISLNK(m) (((m) & (S_IFMT)) == S_IFLNK)
#endif
#endif

/* Bletch!  SPARC compiler doesn't define sparc (needed by
   arpa/nameser.h) when in -Xc mode.  Luckily, it always defines
   __sparc.  */
#ifdef __sparc
#ifndef sparc
#define sparc
#endif
#endif


#ifdef WINDOWS
#ifndef S_ISDIR
# define S_ISDIR(m) (((m) & (_S_IFMT)) == (_S_IFDIR))
#endif
#ifndef S_ISLNK
# define S_ISLNK(a) 0
#endif
#endif /* WINDOWS */

/* Windows doesn't have sleep */
#ifdef WINDOWS
#  define sleep(t) Sleep(1000 * (t))
#endif   

#endif /* SYSTHINGS_H */
